/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.fej1fun.potentials.components.FluidAmountMapDataComponent;
import com.fej1fun.potentials.providers.FluidProvider;
import com.st0x0ef.stellaris.common.blocks.entities.machines.BaseEnergyContainerBlockEntity;
import com.st0x0ef.stellaris.common.data.recipes.FuelRefineryRecipe;
import com.st0x0ef.stellaris.common.data.recipes.input.FluidInput;
import com.st0x0ef.stellaris.common.menus.FuelRefineryMenu;
import com.st0x0ef.stellaris.common.network.packets.SyncFluidPacket;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.registry.FluidRegistry;
import com.st0x0ef.stellaris.common.registry.RecipesRegistry;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.FluidUtil;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.SingleFluidStorage;
import dev.architectury.fluid.FluidStack;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FuelRefineryBlockEntity
extends BaseEnergyContainerBlockEntity
implements FluidProvider.BLOCK {
    private final SingleFluidStorage inputTank;
    private final SingleFluidStorage outputFuelTank;
    private final SingleFluidStorage outputDieselTank;
    private final RecipeManager.CachedCheck<FluidInput, FuelRefineryRecipe> cachedCheck = RecipeManager.createCheck((RecipeType)((RecipeType)RecipesRegistry.FUEL_REFINERY_TYPE.get()));

    public FuelRefineryBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.FUEL_REFINERY.get(), pos, state);
        this.inputTank = new SingleFluidStorage(10000L){

            @Override
            protected void onChange() {
                FuelRefineryBlockEntity.this.setChanged();
                if (FuelRefineryBlockEntity.this.level != null && FuelRefineryBlockEntity.this.level.getServer() != null && !FuelRefineryBlockEntity.this.level.getServer().getPlayerList().getPlayers().isEmpty()) {
                    NetworkManager.sendToPlayers((Iterable)FuelRefineryBlockEntity.this.level.getServer().getPlayerList().getPlayers(), (CustomPacketPayload)new SyncFluidPacket(new FluidAmountMapDataComponent(List.of(this.getFluidInTank(0).getFluid()), List.of(Long.valueOf(this.getFluidValueInTank()))), 0, FuelRefineryBlockEntity.this.getBlockPos(), Direction.UP));
                }
            }

            @Override
            public boolean isFluidValid(int tank, FluidStack stack) {
                return stack.getFluid().isSame((Fluid)FluidRegistry.OIL_STILL.get());
            }
        };
        this.outputFuelTank = new SingleFluidStorage(10000L){

            @Override
            protected void onChange() {
                FuelRefineryBlockEntity.this.setChanged();
                if (FuelRefineryBlockEntity.this.level != null && FuelRefineryBlockEntity.this.level.getServer() != null && !FuelRefineryBlockEntity.this.level.getServer().getPlayerList().getPlayers().isEmpty()) {
                    NetworkManager.sendToPlayers((Iterable)FuelRefineryBlockEntity.this.level.getServer().getPlayerList().getPlayers(), (CustomPacketPayload)new SyncFluidPacket(new FluidAmountMapDataComponent(List.of(this.getFluidInTank(0).getFluid()), List.of(Long.valueOf(this.getFluidValueInTank()))), 0, FuelRefineryBlockEntity.this.getBlockPos(), Direction.NORTH));
                }
            }
        };
        this.outputDieselTank = new SingleFluidStorage(10000L){

            @Override
            protected void onChange() {
                FuelRefineryBlockEntity.this.setChanged();
                if (FuelRefineryBlockEntity.this.level != null && FuelRefineryBlockEntity.this.level.getServer() != null && !FuelRefineryBlockEntity.this.level.getServer().getPlayerList().getPlayers().isEmpty()) {
                    NetworkManager.sendToPlayers((Iterable)FuelRefineryBlockEntity.this.level.getServer().getPlayerList().getPlayers(), (CustomPacketPayload)new SyncFluidPacket(new FluidAmountMapDataComponent(List.of(this.getFluidInTank(0).getFluid()), List.of(Long.valueOf(this.getFluidValueInTank()))), 0, FuelRefineryBlockEntity.this.getBlockPos(), Direction.SOUTH));
                }
            }
        };
    }

    @Override
    public void tick() {
        FluidUtil.moveFluidToItem(0, this.inputTank, 1, (NonNullList<ItemStack>)this.items, 1000L);
        FluidUtil.moveFluidToItem(0, this.outputFuelTank, 2, (NonNullList<ItemStack>)this.items, 1000L);
        FluidUtil.moveFluidToItem(0, this.outputDieselTank, 4, (NonNullList<ItemStack>)this.items, 1000L);
        FluidUtil.moveFluidFromItem(0, 0, (NonNullList<ItemStack>)this.items, this.inputTank, 1000L);
        if (this.level == null) {
            return;
        }
        Optional recipeHolder = this.cachedCheck.getRecipeFor((RecipeInput)new FluidInput(this.level.getBlockEntity(this.getBlockPos())), this.level);
        if (recipeHolder.isPresent()) {
            FuelRefineryRecipe recipe = (FuelRefineryRecipe)((RecipeHolder)recipeHolder.get()).value();
            if (this.energyContainer.getEnergy() >= recipe.energy() && this.inputTank.getFluidValueInTank() >= recipe.ingredientStack().getAmount() && (this.outputFuelTank.getFluidInTank(0).isEmpty() || this.outputFuelTank.getFluidInTank(0).isFluidEqual(recipe.fuelStack())) && (this.outputDieselTank.getFluidInTank(0).isEmpty() || this.outputDieselTank.getFluidInTank(0).isFluidEqual(recipe.dieselStack()))) {
                boolean shouldUseEnergyAndDrainOil = false;
                if (this.outputFuelTank.getFluidValueInTank() + recipe.fuelStack().getAmount() < this.outputFuelTank.getTankCapacity(0)) {
                    this.outputFuelTank.fill(recipe.fuelStack().copy(), false);
                    shouldUseEnergyAndDrainOil = true;
                }
                if (this.outputDieselTank.getFluidValueInTank() + recipe.dieselStack().getAmount() < this.outputDieselTank.getTankCapacity(0)) {
                    this.outputDieselTank.fill(recipe.dieselStack().copy(), false);
                    shouldUseEnergyAndDrainOil = true;
                }
                if (shouldUseEnergyAndDrainOil) {
                    this.inputTank.drain(recipe.ingredientStack().copy(), false);
                    this.energyContainer.extract(recipe.energy(), false);
                    this.setChanged();
                }
            }
        }
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)"block.stellaris.fuel_refinery");
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int containerId, Inventory inventory) {
        return new FuelRefineryMenu(containerId, inventory, (Container)this, this);
    }

    @Override
    public int getContainerSize() {
        return 6;
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.inputTank.load(tag, provider, "input");
        this.outputFuelTank.load(tag, provider, "fuel");
        this.outputDieselTank.load(tag, provider, "diesel");
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.inputTank.save(tag, provider, "input");
        this.outputFuelTank.save(tag, provider, "fuel");
        this.outputDieselTank.save(tag, provider, "diesel");
    }

    public SingleFluidStorage getIngredientTank() {
        return this.inputTank;
    }

    public SingleFluidStorage getOutputFuelTank() {
        return this.outputFuelTank;
    }

    public SingleFluidStorage getOutputDieselTank() {
        return this.outputDieselTank;
    }

    @Nullable
    public SingleFluidStorage getFluidTank(@Nullable Direction direction) {
        if (direction == null) {
            return this.inputTank;
        }
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.UP, Direction.DOWN -> this.inputTank;
            case Direction.EAST, Direction.NORTH -> this.outputFuelTank;
            case Direction.WEST, Direction.SOUTH -> this.outputDieselTank;
        };
    }
}

