/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import com.fej1fun.potentials.providers.FluidProvider;
import com.st0x0ef.stellaris.common.blocks.entities.machines.TickingBlockEntity;
import com.st0x0ef.stellaris.common.blocks.machines.PipeBlock;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.FluidUtil;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.SingleFluidStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PipeBlockEntity
extends BlockEntity
implements FluidProvider.BLOCK,
TickingBlockEntity {
    private final SingleFluidStorage fluidTank;

    public PipeBlockEntity(BlockPos pos, BlockState blockState, long capacity, long maxIn, long maxOut) {
        super(BlockEntityRegistry.PIPE_ENTITY.get(), pos, blockState);
        this.fluidTank = new SingleFluidStorage(capacity, maxIn, maxOut){

            @Override
            protected void onChange() {
                PipeBlockEntity.this.setChanged();
            }
        };
    }

    public static PipeBlockEntity create(BlockPos pos, BlockState state) {
        Block block = state.getBlock();
        if (block instanceof PipeBlock) {
            PipeBlock block2 = (PipeBlock)block;
            return new PipeBlockEntity(pos, state, block2.capacity, block2.maxIn, block2.maxOut);
        }
        return new PipeBlockEntity(pos, state, 0L, 0L, 0L);
    }

    @Nullable
    public UniversalFluidStorage getFluidTank(@Nullable Direction direction) {
        return this.fluidTank;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.fluidTank.load(tag, registries, "fluid");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.fluidTank.save(tag, registries, "fluid");
    }

    @Override
    public void tick() {
        FluidUtil.distributeFluidNearby(this.level, this.worldPosition, this.fluidTank.getFluidInTank(0));
    }
}

