/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.blocks.entities.machines;

import com.fej1fun.potentials.components.FluidAmountMapDataComponent;
import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import com.fej1fun.potentials.providers.FluidProvider;
import com.st0x0ef.stellaris.common.blocks.entities.machines.BaseEnergyBlockEntity;
import com.st0x0ef.stellaris.common.network.packets.SyncFluidPacketWithoutDirection;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.FluidUtil;
import com.st0x0ef.stellaris.common.utils.capabilities.fluid.SingleFluidStorage;
import dev.architectury.fluid.FluidStack;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WaterPumpBlockEntity
extends BaseEnergyBlockEntity
implements FluidProvider.BLOCK {
    private static final int NEEDED_ENERGY = 100;
    private final SingleFluidStorage waterTank = new SingleFluidStorage(1000L){

        @Override
        protected void onChange() {
            WaterPumpBlockEntity.this.setChanged();
            if (WaterPumpBlockEntity.this.level != null && WaterPumpBlockEntity.this.level.getServer() != null && !WaterPumpBlockEntity.this.level.getServer().getPlayerList().getPlayers().isEmpty()) {
                NetworkManager.sendToPlayers((Iterable)WaterPumpBlockEntity.this.level.getServer().getPlayerList().getPlayers(), (CustomPacketPayload)new SyncFluidPacketWithoutDirection(new FluidAmountMapDataComponent(List.of(this.getFluidInTank(0).getFluid()), List.of(Long.valueOf(this.getFluidValueInTank()))), 0, WaterPumpBlockEntity.this.getBlockPos()));
            }
        }
    };

    public WaterPumpBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.WATER_PUMP.get(), pos, state, 100);
    }

    @Override
    public void tick() {
        if (this.level == null) {
            return;
        }
        if (this.energyContainer.getEnergy() < 100) {
            return;
        }
        BlockPos belowPos = this.worldPosition.below();
        FluidState belowFluidState = this.level.getFluidState(belowPos);
        if (belowFluidState.is((Fluid)Fluids.WATER) && belowFluidState.isSource()) {
            BucketPickup bucketPickup;
            Block block;
            BlockState belowState = this.level.getBlockState(belowPos);
            if (this.waterTank.getFluidInTank(0).isEmpty() && (block = belowState.getBlock()) instanceof BucketPickup && !(bucketPickup = (BucketPickup)block).pickupBlock(null, (LevelAccessor)this.level, belowPos, belowState).isEmpty()) {
                this.waterTank.fill(FluidStack.create((Fluid)Fluids.WATER, (long)1000L), false);
                this.energyContainer.extract(100, false);
            }
        }
        FluidUtil.distributeFluidNearby(this.level, this.worldPosition, this.waterTank.getFluidInTank(0), List.of(Direction.UP));
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.waterTank.load(tag, provider, "water");
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.waterTank.save(tag, provider, "water");
    }

    public SingleFluidStorage getWaterTank() {
        return this.waterTank;
    }

    @NotNull
    public UniversalFluidStorage getFluidTank(@Nullable Direction direction) {
        return this.waterTank;
    }
}

