/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.data.screen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.events.custom.PlanetSelectionClientEvents;
import com.st0x0ef.stellaris.client.screens.PlanetSelectionScreen;
import com.st0x0ef.stellaris.client.screens.info.MoonInfo;
import com.st0x0ef.stellaris.client.screens.record.MoonRecord;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MoonPack
extends SimpleJsonResourceReloadListener {
    public static final Map<String, MoonRecord> MOON = new HashMap<String, MoonRecord>();
    public static int count = 0;

    public MoonPack() {
        super(Stellaris.GSON, "renderer/planet_screen/moon");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        if (count > 0) {
            return;
        }
        MOON.clear();
        object.forEach((key, value) -> {
            JsonObject json = GsonHelper.convertToJsonObject((JsonElement)value, (String)"moons");
            MoonRecord moon = (MoonRecord)MoonRecord.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow();
            MOON.put(moon.name(), moon);
            MoonInfo screenMoon = new MoonInfo(moon.texture(), moon.name(), (int)moon.distance(), moon.period(), (int)moon.width(), (int)moon.height(), PlanetSelectionScreen.findByNamePlanet(moon.parent()), moon.dimensionId().location(), moon.translatable(), moon.id());
            moon.clickable().ifPresent(screenMoon::setClickable);
            moon.spaceStation().ifPresent(screenMoon::setSpaceStation);
            moon.canLaunchOn().ifPresent(screenMoon::setCanLaunchOn);
            for (int i = 0; i < PlanetSelectionScreen.MOONS.size(); ++i) {
                if (!PlanetSelectionScreen.MOONS.get(i).getId().equals(screenMoon.getId())) continue;
                PlanetSelectionScreen.MOONS.set(i, screenMoon);
                Stellaris.LOG.info("Replaced existing moon in PlanetSelectionScreen : {}", (Object)moon.name());
                return;
            }
            PlanetSelectionScreen.MOONS.add(screenMoon);
            Stellaris.LOG.info("Added a new moon to PlanetSelectionScreen : {}", (Object)moon.name());
        });
        ((PlanetSelectionClientEvents.PostMoonPackRegistryEvent)PlanetSelectionClientEvents.POST_MOON_PACK_REGISTRY.invoker()).moonRegistered(PlanetSelectionScreen.MOONS);
        ++count;
    }
}

