/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.launchpads;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public record LaunchPad(int id, Vec3 position, ResourceKey<Level> dimension, String name, Boolean isPublic, String owner, List<String> whitelist) {
    public static final Codec<LaunchPad> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("id").forGetter(launchPad -> (int)launchPad.position().x), (App)Vec3.CODEC.fieldOf("position").forGetter(LaunchPad::position), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("dimension").forGetter(LaunchPad::dimension), (App)Codec.STRING.fieldOf("name").forGetter(LaunchPad::name), (App)Codec.BOOL.fieldOf("public").forGetter(LaunchPad::isPublic), (App)Codec.STRING.fieldOf("owner").forGetter(LaunchPad::name), (App)Codec.STRING.listOf().fieldOf("whitelist").forGetter(LaunchPad::whitelist)).apply((Applicative)instance, LaunchPad::new));

    @Override
    public String toString() {
        return "LaunchPad : id=" + this.id + ", position=" + String.valueOf(this.position) + ", dimension=" + String.valueOf(this.dimension) + ", name='" + this.name + "', isPublic=" + this.isPublic + ", owner='" + this.owner + "', whitelist=" + String.valueOf(this.whitelist) + "}";
    }

    public static RegistryFriendlyByteBuf toBuffer(LaunchPad launchPad, RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(launchPad.id);
        buffer.writeVec3(launchPad.position());
        buffer.writeResourceKey(launchPad.dimension());
        buffer.writeUtf(launchPad.name());
        buffer.writeBoolean(launchPad.isPublic().booleanValue());
        buffer.writeUtf(launchPad.owner());
        buffer.writeInt(launchPad.whitelist().size());
        launchPad.whitelist().forEach(arg_0 -> ((RegistryFriendlyByteBuf)buffer).writeUtf(arg_0));
        return buffer;
    }

    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("id", (Number)this.id);
        JsonArray pos = new JsonArray();
        pos.add((Number)this.position.x);
        pos.add((Number)this.position.y);
        pos.add((Number)this.position.z);
        json.add("position", (JsonElement)pos);
        json.addProperty("dimension", this.dimension.location().toString());
        json.addProperty("name", this.name);
        json.addProperty("public", this.isPublic);
        json.addProperty("owner", this.owner);
        JsonArray whitelist = new JsonArray();
        for (String s : this.whitelist) {
            whitelist.add(s);
        }
        json.add("whitelist", (JsonElement)whitelist);
        return json;
    }

    public static JsonElement toJson(LaunchPad instance) {
        return (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)instance).result().orElseThrow(() -> new IllegalStateException("Failed to encode to JSON"));
    }

    public static LaunchPad readFromBuffer(RegistryFriendlyByteBuf buffer) {
        int id = buffer.readInt();
        Vec3 position = buffer.readVec3();
        ResourceKey dimension = buffer.readResourceKey(Registries.DIMENSION);
        String name = buffer.readUtf();
        boolean isPublic = buffer.readBoolean();
        String owner = buffer.readUtf();
        int whitelistSize = buffer.readInt();
        ArrayList<String> whitelist = new ArrayList<String>();
        for (int i = 0; i < whitelistSize; ++i) {
            whitelist.add(buffer.readUtf());
        }
        return new LaunchPad(id, position, (ResourceKey<Level>)dimension, name, isPublic, owner, whitelist);
    }

    public record LaunchPadContainer(List<LaunchPad> launchPads) {
        public static final Codec<LaunchPadContainer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CODEC.listOf().fieldOf("launchpads").forGetter(LaunchPadContainer::launchPads)).apply((Applicative)instance, LaunchPadContainer::new));
        public static LaunchPadContainer DEFAULT = new LaunchPadContainer(new ArrayList<LaunchPad>());

        public static RegistryFriendlyByteBuf toBuffer(LaunchPadContainer launchPads, RegistryFriendlyByteBuf buffer) {
            buffer.writeInt(launchPads.launchPads.size());
            launchPads.launchPads.forEach(launchPad -> LaunchPad.toBuffer(launchPad, buffer));
            return buffer;
        }

        public static LaunchPadContainer readFromBuffer(RegistryFriendlyByteBuf buffer) {
            int size = buffer.readInt();
            ArrayList<LaunchPad> launchPads = new ArrayList<LaunchPad>();
            for (int i = 0; i < size; ++i) {
                launchPads.add(LaunchPad.readFromBuffer(buffer));
            }
            return new LaunchPadContainer(launchPads);
        }

        public static JsonElement toJson(LaunchPadContainer instance) {
            JsonObject json = new JsonObject();
            JsonArray launchPadArray = new JsonArray();
            for (LaunchPad launchPad : instance.launchPads) {
                launchPadArray.add(launchPad.toJson());
            }
            json.add("launchpads", (JsonElement)launchPadArray);
            return json;
        }
    }
}

