/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.entity;

import biomesoplenty.api.entity.BOPEntities;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.entity.BoatBOP;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ChestBoatBOP
extends ChestBoat {
    public ChestBoatBOP(EntityType<? extends ChestBoatBOP> type, Level level) {
        super(type, level);
        this.blocksBuilding = true;
    }

    public ChestBoatBOP(Level level, double x, double y, double z) {
        this(BOPEntities.CHEST_BOAT, level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return new ClientboundAddEntityPacket((Entity)this, serverEntity);
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.putString("model", this.getModel().getName());
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        if (nbt.contains("model", 8)) {
            this.entityData.set(DATA_ID_TYPE, (Object)BoatBOP.ModelType.byName(nbt.getString("model")).ordinal());
        }
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
        this.lastYd = this.getDeltaMovement().y;
        if (!this.isPassenger()) {
            if (onGround) {
                if (this.fallDistance > 3.0f) {
                    if (this.status != Boat.Status.ON_LAND) {
                        this.resetFallDistance();
                        return;
                    }
                    this.causeFallDamage(this.fallDistance, 1.0f, this.damageSources().fall());
                    if (!this.level().isClientSide && !this.isRemoved()) {
                        this.kill();
                        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                            for (int i = 0; i < 3; ++i) {
                                this.spawnAtLocation((ItemLike)this.getModel().getPlanks());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.spawnAtLocation((ItemLike)Items.STICK);
                            }
                        }
                    }
                }
                this.resetFallDistance();
            } else if (!this.level().getFluidState(this.blockPosition().below()).is(FluidTags.WATER) && y < 0.0) {
                this.fallDistance -= (float)y;
            }
        }
    }

    public Item getDropItem() {
        switch (BoatBOP.ModelType.byId((Integer)this.entityData.get(DATA_ID_TYPE))) {
            case FIR: {
                return BOPItems.FIR_CHEST_BOAT;
            }
            case PINE: {
                return BOPItems.PINE_CHEST_BOAT;
            }
            case MAPLE: {
                return BOPItems.MAPLE_CHEST_BOAT;
            }
            case REDWOOD: {
                return BOPItems.REDWOOD_CHEST_BOAT;
            }
            case MAHOGANY: {
                return BOPItems.MAHOGANY_CHEST_BOAT;
            }
            case JACARANDA: {
                return BOPItems.JACARANDA_CHEST_BOAT;
            }
            case PALM: {
                return BOPItems.PALM_CHEST_BOAT;
            }
            case WILLOW: {
                return BOPItems.WILLOW_CHEST_BOAT;
            }
            case DEAD: {
                return BOPItems.DEAD_CHEST_BOAT;
            }
            case MAGIC: {
                return BOPItems.MAGIC_CHEST_BOAT;
            }
            case UMBRAN: {
                return BOPItems.UMBRAN_CHEST_BOAT;
            }
            case HELLBARK: {
                return BOPItems.HELLBARK_CHEST_BOAT;
            }
            case EMPYREAL: {
                return BOPItems.EMPYREAL_CHEST_BOAT;
            }
        }
        return Items.OAK_CHEST_BOAT;
    }

    public void setModel(BoatBOP.ModelType type) {
        this.entityData.set(DATA_ID_TYPE, (Object)type.ordinal());
    }

    public BoatBOP.ModelType getModel() {
        return BoatBOP.ModelType.byId((Integer)this.entityData.get(DATA_ID_TYPE));
    }

    @Deprecated
    public void setVariant(Boat.Type vanillaType) {
    }

    @Deprecated
    public Boat.Type getVariant() {
        return Boat.Type.OAK;
    }
}

