/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.init.ModTags;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class BarnacleFeature
extends Feature<NoneFeatureConfiguration> {
    public BarnacleFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel worldIn = featurePlaceContext.level();
        ChunkGenerator chunkGenerator = featurePlaceContext.chunkGenerator();
        RandomSource rand = featurePlaceContext.random();
        BlockPos pos = featurePlaceContext.origin();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.config();
        int i = 0;
        int j = rand.nextInt(6) + 2;
        for (int k = pos.getX() - j; k <= pos.getX() + j; ++k) {
            block1: for (int l = pos.getZ() - j; l <= pos.getZ() + j; ++l) {
                int j1;
                int i1 = k - pos.getX();
                if (i1 * i1 + (j1 = l - pos.getZ()) * j1 > j * j) continue;
                for (int k1 = pos.getY() - j; k1 <= pos.getY() + j; ++k1) {
                    BlockPos blockpos = new BlockPos(k, k1, l);
                    BlockState blockstate = worldIn.getBlockState(blockpos);
                    BlockState barnaclestate = BOPBlocks.BARNACLES.defaultBlockState();
                    int faces = 0;
                    for (Direction direction : Direction.values()) {
                        BlockState blockstate1 = worldIn.getBlockState(blockpos.relative(direction));
                        if (rand.nextInt(4) != 0 || blockstate1 != Blocks.END_STONE.defaultBlockState() && blockstate1 != BOPBlocks.UNMAPPED_END_STONE.defaultBlockState() && blockstate1 != BOPBlocks.NULL_END_STONE.defaultBlockState() && blockstate1 != BOPBlocks.ALGAL_END_STONE.defaultBlockState() && blockstate1 != BOPBlocks.WHITE_SAND.defaultBlockState() && blockstate1 != BOPBlocks.WHITE_SANDSTONE.defaultBlockState() && !blockstate1.is(ModTags.Blocks.DEAD_CORAL_BLOCKS)) continue;
                        barnaclestate = (BlockState)barnaclestate.setValue((Property)MultifaceBlock.getFaceProperty((Direction)direction), (Comparable)Boolean.valueOf(true));
                        ++faces;
                    }
                    if (!blockstate.isAir() || faces <= 0) continue;
                    worldIn.setBlock(blockpos, barnaclestate, 2);
                    ++i;
                    continue block1;
                }
            }
        }
        return i > 0;
    }
}

