/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class GrassSplatterFeature
extends Feature<NoneFeatureConfiguration> {
    public GrassSplatterFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel worldIn = featurePlaceContext.level();
        ChunkGenerator chunkGenerator = featurePlaceContext.chunkGenerator();
        RandomSource rand = featurePlaceContext.random();
        BlockPos pos = featurePlaceContext.origin();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.config();
        int i = 0;
        int j = rand.nextInt(6) + 2;
        for (int k = pos.getX() - j; k <= pos.getX() + j; ++k) {
            block1: for (int l = pos.getZ() - j; l <= pos.getZ() + j; ++l) {
                int j1;
                int i1 = k - pos.getX();
                if (i1 * i1 + (j1 = l - pos.getZ()) * j1 > j * j) continue;
                for (int k1 = pos.getY() - 2; k1 <= pos.getY() + 2; ++k1) {
                    BlockPos blockpos = new BlockPos(k, k1, l);
                    BlockState blockstate = worldIn.getBlockState(blockpos);
                    BlockState blockstate1 = worldIn.getBlockState(blockpos.above());
                    if (blockstate.getBlock() != BOPBlocks.BLACK_SAND) continue;
                    if (!GrassSplatterFeature.isAir((LevelSimulatedReader)worldIn, blockpos.above())) continue;
                    if (rand.nextInt(2) > 0) {
                        worldIn.setBlock(blockpos, BOPBlocks.MOSSY_BLACK_SAND.defaultBlockState(), 2);
                        if (rand.nextInt(3) == 0) {
                            worldIn.setBlock(blockpos.above(), Blocks.FERN.defaultBlockState(), 2);
                        }
                    }
                    ++i;
                    continue block1;
                }
            }
        }
        return i > 0;
    }

    public static boolean isAir(LevelSimulatedReader level, BlockPos pos) {
        return level.isStateAtPosition(pos, BlockBehaviour.BlockStateBase::isAir);
    }
}

