/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.compat.CompatComponent;
import com.b1n_ry.yigd.compat.InvModCompat;
import com.b1n_ry.yigd.components.InventoryComponent;
import com.b1n_ry.yigd.config.CompatConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.data.GraveItem;
import com.b1n_ry.yigd.events.YigdEvents;
import com.b1n_ry.yigd.util.DropRule;
import java.util.Collection;
import java.util.function.Predicate;
import lain.mods.cos.impl.ModObjects;
import lain.mods.cos.impl.inventory.InventoryCosArmor;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class CosmeticArmorCompat
implements InvModCompat<NonNullList<GraveItem>> {
    @Override
    public String getModName() {
        return "cosmeticarmor";
    }

    @Override
    public void clear(ServerPlayer player) {
        InventoryCosArmor inv = ModObjects.invMan.getCosArmorInventory(player.getUUID());
        inv.clearContent();
    }

    @Override
    public CompatComponent<NonNullList<GraveItem>> readNbt(CompoundTag nbt, HolderLookup.Provider registries) {
        NonNullList<GraveItem> items = InventoryComponent.listFromNbt(nbt, itemTag -> {
            DropRule dropRule = DropRule.valueOf(itemTag.getString("dropRule"));
            ItemStack stack = ItemStack.parse((HolderLookup.Provider)registries, (Tag)itemTag).orElse(ItemStack.EMPTY);
            return new GraveItem(stack, dropRule);
        }, InventoryComponent.EMPTY_GRAVE_ITEM);
        return new CosmeticArmorCompatComponent(items);
    }

    @Override
    public CompatComponent<NonNullList<GraveItem>> getNewComponent(ServerPlayer player) {
        return new CosmeticArmorCompatComponent(player);
    }

    static class CosmeticArmorCompatComponent
    extends CompatComponent<NonNullList<GraveItem>> {
        public CosmeticArmorCompatComponent(ServerPlayer player) {
            super(player);
        }

        public CosmeticArmorCompatComponent(NonNullList<GraveItem> inventory) {
            super(inventory);
        }

        @Override
        public NonNullList<GraveItem> getInventory(ServerPlayer player) {
            InventoryCosArmor inventory = ModObjects.invMan.getCosArmorInventory(player.getUUID());
            NonNullList list = NonNullList.create();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                ItemStack stack = inventory.getItem(i);
                list.add((Object)new GraveItem(stack, DropRule.PUT_IN_GRAVE));
            }
            return list;
        }

        @Override
        public NonNullList<ItemStack> storeToPlayer(ServerPlayer player) {
            NonNullList extraItems = NonNullList.create();
            InventoryCosArmor cosArmor = ModObjects.invMan.getCosArmorInventory(player.getUUID());
            for (int i = 0; i < cosArmor.getContainerSize() && i < ((NonNullList)this.inventory).size(); ++i) {
                GraveItem graveItem = ((GraveItem)((NonNullList)this.inventory).get(i)).copy();
                if (cosArmor.getItem(i).isEmpty()) {
                    cosArmor.setItem(i, graveItem.stack);
                    continue;
                }
                extraItems.add((Object)graveItem.stack);
            }
            return extraItems;
        }

        @Override
        public void handleDropRules(DeathContext context) {
            CompatConfig compatConfig = YigdConfig.getConfig().compatConfig;
            for (GraveItem graveItem : (NonNullList)this.inventory) {
                DropRule dropRule;
                if (graveItem.stack.isEmpty() || (dropRule = compatConfig.defaultCosmeticArmorDropRule) != DropRule.PUT_IN_GRAVE) continue;
                graveItem.dropRule = dropRule = ((YigdEvents.DropRuleEvent)NeoForge.EVENT_BUS.post((Event)new YigdEvents.DropRuleEvent(graveItem.stack, -1, context, true))).getDropRule();
            }
        }

        @Override
        public NonNullList<GraveItem> getAsGraveItemList() {
            return NonNullList.copyOf((Collection)((Collection)this.inventory));
        }

        @Override
        public void clear() {
            ((NonNullList)this.inventory).clear();
        }

        @Override
        public CompoundTag writeNbt(HolderLookup.Provider registries) {
            return InventoryComponent.listToNbt((NonNullList)this.inventory, graveItem -> {
                CompoundTag itemTag = (CompoundTag)graveItem.stack.save(registries);
                itemTag.putString("dropRule", graveItem.dropRule.toString());
                return itemTag;
            }, graveItem -> graveItem.stack.isEmpty());
        }

        @Override
        public boolean removeItem(Predicate<ItemStack> predicate, int itemCount) {
            for (GraveItem graveItem : (NonNullList)this.inventory) {
                ItemStack stack = graveItem.stack;
                if (!predicate.test(stack)) continue;
                stack.shrink(itemCount);
                return true;
            }
            return false;
        }

        @Override
        public CompatComponent<NonNullList<GraveItem>> filterInv(Predicate<DropRule> predicate) {
            NonNullList list = NonNullList.create();
            for (GraveItem graveItem : (NonNullList)this.inventory) {
                if (predicate.test(graveItem.dropRule)) {
                    list.add((Object)graveItem);
                    continue;
                }
                list.add((Object)InventoryComponent.EMPTY_GRAVE_ITEM);
            }
            return new CosmeticArmorCompatComponent((NonNullList<GraveItem>)list);
        }

        @Override
        public NonNullList<GraveItem> merge(CompatComponent<?> mergingComponent, ServerPlayer merger) {
            NonNullList extraItems = NonNullList.create();
            NonNullList mergingItems = (NonNullList)mergingComponent.inventory;
            for (int i = 0; i < mergingItems.size(); ++i) {
                GraveItem graveItem = (GraveItem)mergingItems.get(i);
                if (i >= ((NonNullList)this.inventory).size()) {
                    extraItems.add((Object)graveItem);
                    continue;
                }
                ItemStack thisStack = ((GraveItem)((NonNullList)this.inventory).get((int)i)).stack;
                if (thisStack.isEmpty()) {
                    ((NonNullList)this.inventory).set(i, (Object)graveItem);
                    continue;
                }
                extraItems.add((Object)graveItem);
            }
            return extraItems;
        }
    }
}

