/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.client;

import java.util.List;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.client.BetterCombatClientMod;
import net.bettercombat.logic.EntityAttributeHelper;
import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.logic.WeaponRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class WeaponAttributeTooltip {
    public static void modifyTooltip(ItemStack itemStack, List<Component> lines) {
        WeaponAttributes attributes = WeaponRegistry.getAttributes(itemStack);
        if (attributes != null) {
            int lastAttributeLine = 0;
            int firstHandLine = 0;
            Integer lastGreenAttributeIndex = null;
            String attributePrefix = "attribute.modifier";
            String attributeEqualsPrefix = "attribute.modifier.equals.0";
            String handPrefix = "item.modifiers";
            for (int i = 0; i < lines.size(); ++i) {
                Component line = lines.get(i);
                ComponentContents content = line.getContents();
                if (content instanceof TranslatableContents) {
                    TranslatableContents translatableText = (TranslatableContents)content;
                    String key = translatableText.getKey();
                    if (key.startsWith(attributePrefix)) {
                        lastAttributeLine = i;
                    }
                    if (firstHandLine != 0 || !key.startsWith(handPrefix)) continue;
                    firstHandLine = i;
                    continue;
                }
                for (Component part : line.getSiblings()) {
                    ComponentContents partContent = part.getContents();
                    if (!(partContent instanceof TranslatableContents)) continue;
                    TranslatableContents translatableText = (TranslatableContents)partContent;
                    if (translatableText.getKey().contains(attributeEqualsPrefix)) {
                        lastGreenAttributeIndex = i;
                    }
                    if (!translatableText.getKey().startsWith(attributePrefix)) continue;
                    lastAttributeLine = i;
                }
            }
            double range = 0.0;
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null && !EntityAttributeHelper.itemHasRangeAttribute(itemStack)) {
                range = PlayerAttackHelper.getStaticRange((Player)player, itemStack);
            }
            if (BetterCombatClientMod.config.isTooltipAttackRangeEnabled && attributes.attacks() != null && attributes.attacks().length > 0 && range > 0.0) {
                Component rangeLine = WeaponAttributeTooltip.attackRangeLine(range);
                int index = lastGreenAttributeIndex != null ? lastGreenAttributeIndex : lastAttributeLine;
                lines.add(index + 1, rangeLine);
            }
            if (attributes.isTwoHanded() && firstHandLine > 0) {
                MutableComponent handLine = Component.translatable((String)"item.held.two_handed").withStyle(ChatFormatting.GRAY);
                lines.add(firstHandLine, (Component)handLine);
            }
        }
    }

    public static Component attackRangeLine(double range) {
        int operationId = AttributeModifier.Operation.ADD_VALUE.id();
        String rangeTranslationKey = "attribute.name.generic.attack_range";
        return CommonComponents.space().append((Component)Component.translatable((String)("attribute.modifier.equals." + operationId), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(range), Component.translatable((String)rangeTranslationKey)})).withStyle(ChatFormatting.DARK_GREEN);
    }
}

