/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.immersiveui.neoforge.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import it.hurts.octostudios.immersiveui.client.MouseInfo;
import it.hurts.octostudios.immersiveui.compat.ExtraScreenData;
import it.hurts.octostudios.immersiveui.util.CommonCode;
import it.hurts.octostudios.octolib.client.particle.ParticleSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.inventory.Slot;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingLogicContainer;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeContainer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StorageScreenBase.class})
public abstract class StorageScreenBaseMixin {
    @Shadow
    private boolean initializing;
    @Unique
    Map<Slot, Float> backpackProgress = new HashMap<Slot, Float>();
    @Unique
    Slot myHoveredSlot;
    @Unique
    AtomicReference<Float> timer = new AtomicReference<Float>(Float.valueOf(0.0f));
    @Unique
    AtomicBoolean shouldBurstCompat = new AtomicBoolean(false);

    @Shadow
    protected abstract boolean isHovering(Slot var1, double var2, double var4);

    @Shadow
    public abstract int getLeftX();

    @Shadow
    public abstract int getTopY();

    @Inject(require=0, method={"renderBg(Lnet/minecraft/client/gui/GuiGraphics;FII)V"}, at={@At(value="HEAD")})
    public void shake(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY, CallbackInfo ci) {
        CommonCode.shakeScreen(guiGraphics, (Screen)this, this.timer, 2.0f);
    }

    @Inject(require=0, method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="TAIL")})
    public void resetOldMouse2(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        MouseInfo mouseInfo = ((ExtraScreenData)((Object)this)).getMouseInfo();
        mouseInfo.oX = mouseX;
        mouseInfo.oY = mouseY;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)this.getLeftX(), (float)this.getTopY(), 0.0f);
        ParticleSystem.renderScreenParticles((Screen)((Screen)this), (GuiGraphics)guiGraphics, (float)Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(false));
        guiGraphics.pose().popPose();
    }

    @Inject(require=0, method={"renderSuper(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="HEAD")})
    private void renderHead(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        this.myHoveredSlot = null;
    }

    @Inject(require=0, method={"renderSuper(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/p3pp3rf1y/sophisticatedcore/client/gui/StorageScreenBase;renderSlot(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/inventory/Slot;)V", shift=At.Shift.BEFORE)})
    private void hoveredSlot(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci, @Local Slot slot) {
        if (this.isHovering(slot, mouseX, mouseY)) {
            this.myHoveredSlot = slot;
        }
    }

    @Inject(require=0, method={"renderUpgradeSlots(Lnet/minecraft/client/gui/GuiGraphics;II)V"}, at={@At(value="INVOKE", target="Lnet/p3pp3rf1y/sophisticatedcore/client/gui/StorageScreenBase;renderSlot(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/inventory/Slot;)V", shift=At.Shift.BEFORE)})
    private void hoveredSlot2(GuiGraphics guiGraphics, int mouseX, int mouseY, CallbackInfo ci, @Local Slot slot) {
        if (this.isHovering(slot, mouseX, mouseY) && slot.isActive()) {
            this.myHoveredSlot = slot;
        }
    }

    @Inject(require=0, method={"renderStorageInventorySlots(Lnet/minecraft/client/gui/GuiGraphics;IIZ)V"}, at={@At(value="INVOKE", target="Lnet/p3pp3rf1y/sophisticatedcore/client/gui/StorageScreenBase;renderSlot(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/inventory/Slot;)V", shift=At.Shift.BEFORE)})
    private void hoveredSlot2(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean canShowHover, CallbackInfo ci, @Local Slot slot) {
        if (canShowHover && this.isHovering(slot, mouseX, mouseY) && slot.isActive()) {
            this.myHoveredSlot = slot;
        }
    }

    @Inject(require=0, method={"renderSlot(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/inventory/Slot;)V"}, at={@At(value="INVOKE", target="Lnet/p3pp3rf1y/sophisticatedcore/client/gui/StorageScreenBase;renderStack(Lnet/minecraft/client/gui/GuiGraphics;IILnet/minecraft/world/item/ItemStack;ZLjava/lang/String;)V", shift=At.Shift.BEFORE)})
    private void renderSize(GuiGraphics guiGraphics, Slot slot, CallbackInfo ci) {
        CommonCode.floatingRenderSize(guiGraphics, slot, this.myHoveredSlot, this.backpackProgress);
        StorageScreenBase screen = (StorageScreenBase)this;
        Optional upgrade = ((StorageContainerMenuBase)screen.getMenu()).getSlotUpgradeContainer(slot);
        if (upgrade.isEmpty()) {
            return;
        }
        Object t = upgrade.get();
        if (t instanceof CookingUpgradeContainer) {
            CookingUpgradeContainer cookingUpgradeContainer = (CookingUpgradeContainer)t;
            if (slot.getSlotIndex() == 1) {
                CookingLogicContainer logic = cookingUpgradeContainer.getSmeltingLogicContainer();
                float litProgress = (float)(logic.getBurnTimeFinish() - Minecraft.getInstance().level.getGameTime()) / (float)logic.getBurnTimeTotal();
                CommonCode.renderFurnaceParticles((Screen)screen, slot, litProgress == 0.0f, logic.isCooking(), this.shouldBurstCompat);
            }
        }
    }
}

