/*
 * Decompiled with CFR 0.152.
 */
package trofers.block.entity;

import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import trofers.Trofers;
import trofers.block.TrophyBlock;
import trofers.registry.ModBlockEntityTypes;
import trofers.registry.ModDataComponents;
import trofers.registry.ModRegistries;
import trofers.trophy.Trophy;
import trofers.trophy.components.EffectInfo;

public class TrophyBlockEntity
extends BlockEntity {
    public static final BlockEntityTicker<TrophyBlockEntity> TICKER = (level, pos, state, blockEntity) -> blockEntity.tick();
    @Nullable
    private ResourceLocation trophyID;
    private int rewardCooldown;
    private float animationOffset;

    public TrophyBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.TROPHY.get(), pos, state);
    }

    @Nullable
    public Trophy getTrophy() {
        return ModRegistries.get(ModRegistries.TROPHIES, this.trophyID);
    }

    public void setTrophy(@Nullable ResourceLocation trophyId, ServerPlayer player) {
        this.trophyID = trophyId;
        this.resetRewardCooldown(player);
        this.onContentsChanged();
    }

    public ItemStack getItem() {
        ItemStack stack = new ItemStack((ItemLike)this.getBlockState().getBlock().asItem());
        stack.applyComponents(this.collectComponents());
        return stack;
    }

    public float getAnimationOffset() {
        if (this.animationOffset == 0.0f && this.level != null) {
            this.animationOffset = this.level.getRandom().nextFloat() * 4000.0f;
        }
        return this.animationOffset;
    }

    public int getTrophyHeight() {
        Block block = this.getBlockState().getBlock();
        if (block instanceof TrophyBlock) {
            TrophyBlock trophy = (TrophyBlock)block;
            return trophy.getHeight();
        }
        return 0;
    }

    public void resetRewardCooldown(@Nullable ServerPlayer player) {
        Trophy trophy = this.getTrophy();
        this.rewardCooldown = (player == null || !player.isCreative()) && trophy != null && trophy.effects().rewards().cooldown() > 0 ? trophy.effects().rewards().cooldown() : 0;
    }

    public void tick() {
        if (this.rewardCooldown > 0) {
            --this.rewardCooldown;
            if (this.level != null) {
                this.level.blockEntityChanged(this.getBlockPos());
            }
        }
    }

    public boolean applyEffect(Player player) {
        Trophy trophy = this.getTrophy();
        if (trophy == null || this.level == null) {
            return false;
        }
        EffectInfo.RewardInfo rewards = trophy.effects().rewards();
        trophy.effects().sound().ifPresent(sound -> {
            Level patt0$temp = this.level;
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                Vec3 pos = Vec3.atCenterOf((Vec3i)this.getBlockPos());
                TrophyBlockEntity.playSound(serverLevel, sound.soundEvent(), pos, sound.volume(), sound.pitch());
            }
        });
        this.giveRewards(rewards, player);
        return trophy.effects().sound().isPresent() || rewards.lootTable().isPresent() && Trofers.CONFIG.general.enableTrophyLoot != false || rewards.mobEffect().isPresent() && Trofers.CONFIG.general.enableTrophyEffects != false;
    }

    private static void playSound(ServerLevel level, ResourceLocation sound, Vec3 pos, float volume, float pitch) {
        double maxDistance = Math.pow(volume > 1.0f ? (double)volume * 16.0 : 16.0, 2.0);
        long seed = level.getRandom().nextLong();
        for (ServerPlayer player : level.players()) {
            double z;
            double y;
            double x = pos.x - player.getX();
            double distance = x * x + (y = pos.y - player.getY()) * y + (z = pos.z - player.getZ()) * z;
            if (distance > maxDistance) continue;
            Holder holder = Holder.direct((Object)SoundEvent.createVariableRangeEvent((ResourceLocation)sound));
            player.connection.send((Packet)new ClientboundSoundPacket(holder, SoundSource.BLOCKS, pos.x(), pos.y(), pos.z(), volume, pitch, seed));
        }
    }

    private void giveRewards(EffectInfo.RewardInfo rewards, Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (!(Trofers.CONFIG.general.enableTrophyLoot.booleanValue() && !rewards.lootTable().isEmpty() || Trofers.CONFIG.general.enableTrophyEffects.booleanValue() && !rewards.mobEffect().isEmpty())) {
            return;
        }
        if (this.rewardCooldown > 0) {
            player.displayClientMessage((Component)Component.translatable((String)String.format("message.%s.reward_cooldown", "trofers"), (Object[])new Object[]{this.getTime(this.rewardCooldown)}), true);
            return;
        }
        this.resetRewardCooldown(serverPlayer);
        this.rewardLoot(rewards);
        this.rewardMobEffect(rewards, player);
    }

    private Component getTime(int ticks) {
        int seconds = (ticks + 20) / 20;
        if (seconds <= 1) {
            return Component.translatable((String)"time.trofers.second");
        }
        if (seconds < 60) {
            return Component.translatable((String)"time.trofers.seconds", (Object[])new Object[]{seconds});
        }
        int minutes = seconds / 60;
        if (minutes <= 1) {
            return Component.translatable((String)"time.trofers.minute");
        }
        if (minutes < 60) {
            return Component.translatable((String)"time.trofers.minutes", (Object[])new Object[]{minutes});
        }
        int hours = minutes / 60;
        if (hours <= 1) {
            return Component.translatable((String)"time.trofers.hour");
        }
        return Component.translatable((String)"time.trofers.hours", (Object[])new Object[]{hours});
    }

    private void rewardMobEffect(EffectInfo.RewardInfo rewards, Player player) {
        if (Trofers.CONFIG.general.enableTrophyEffects.booleanValue()) {
            rewards.mobEffect().map(EffectInfo.MobEffectInfo::createInstance).ifPresent(arg_0 -> ((Player)player).addEffect(arg_0));
        }
    }

    private void rewardLoot(EffectInfo.RewardInfo rewards) {
        if (Trofers.CONFIG.general.enableTrophyLoot.booleanValue()) {
            rewards.lootTable().ifPresent(lootTableLocation -> {
                LootTable lootTable = this.level.getServer().reloadableRegistries().getLootTable(lootTableLocation);
                if (lootTable == LootTable.EMPTY) {
                    Trofers.LOGGER.log(org.apache.logging.log4j.Level.ERROR, "Invalid loot table: {}", lootTableLocation);
                    return;
                }
                LootParams parameters = new LootParams.Builder((ServerLevel)this.level).create(LootContextParamSets.EMPTY);
                lootTable.getRandomItems(parameters).forEach(this::spawnAtLocation);
            });
        }
    }

    public void spawnAtLocation(ItemStack stack) {
        if (!stack.isEmpty() && this.level != null && !this.level.isClientSide) {
            ItemEntity item = new ItemEntity(this.level, (double)this.getBlockPos().getX() + 0.5, (double)this.getBlockPos().getY() + (double)this.getTrophyHeight() / 16.0 + 0.2, (double)this.getBlockPos().getZ() + 0.5, stack);
            item.setDefaultPickUpDelay();
            this.level.addFreshEntity((Entity)item);
        }
    }

    private void onContentsChanged() {
        if (this.level != null) {
            if (!this.level.isClientSide()) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
                this.setChanged();
            } else {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
            }
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        this.loadTrophy(tag);
        this.rewardCooldown = tag.getInt("RewardCooldown");
    }

    public void loadTrophy(CompoundTag tag) {
        this.trophyID = null;
        if (tag.contains("Trophy", 8)) {
            try {
                this.trophyID = ResourceLocation.parse((String)tag.getString("Trophy"));
            }
            catch (ResourceLocationException exception) {
                Trofers.LOGGER.error(String.format("Failed to load trophy for block entity at %s", this.getBlockPos()), (Throwable)exception);
            }
            Trophy trophy = ModRegistries.get(ModRegistries.TROPHIES, this.trophyID);
            if (trophy == null && ModRegistries.trophies() != null) {
                Trofers.LOGGER.error(String.format("Invalid trophy id for block entity at %s: %s", this.getBlockPos(), this.trophyID));
            }
        }
        if (this.getLevel() != null && this.getLevel().isClientSide()) {
            this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        if (this.trophyID != null) {
            tag.putString("Trophy", this.trophyID.toString());
        }
        if (this.rewardCooldown > 0) {
            tag.putInt("RewardCooldown", this.rewardCooldown);
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput dataComponentInput) {
        super.applyImplicitComponents(dataComponentInput);
        this.trophyID = (ResourceLocation)dataComponentInput.getOrDefault((DataComponentType)ModDataComponents.TROPHY.get(), null);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set((DataComponentType)ModDataComponents.TROPHY.get(), (Object)this.trophyID);
    }

    public void removeComponentsFromTag(CompoundTag compoundTag) {
        compoundTag.remove("trophy");
    }
}

