/*
 * Decompiled with CFR 0.152.
 */
package trofers.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import trofers.Trofers;
import trofers.data.ConditionalTrophyDrops;

public class EntityDrops
extends ConditionalTrophyDrops {
    public static final MapCodec<EntityDrops> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> EntityDrops.codecStart(instance).and((App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)ResourceLocation.CODEC).stable().fieldOf("trophies").forGetter(m -> m.trophies)).apply((Applicative)instance, EntityDrops::create));
    public static final Codec<EntityDrops> CODEC = MAP_CODEC.codec();
    public static final EntityDrops NONE = new EntityDrops(List.of(), Items.AIR, new HashMap<ResourceLocation, ResourceLocation>(), new HashSet());
    private final Map<ResourceLocation, ResourceLocation> trophies;
    private final Set<EntityType<?>> entities;

    private EntityDrops(List<LootItemCondition> conditions, Item trophyBase, Map<ResourceLocation, ResourceLocation> trophies, Set<EntityType<?>> entities) {
        super(conditions, trophyBase);
        this.trophies = trophies;
        this.entities = entities;
    }

    public static EntityDrops create(List<LootItemCondition> conditions, ItemLike trophyBase, Map<ResourceLocation, ResourceLocation> trophies) {
        return EntityDrops.create(conditions, trophyBase, trophies, true);
    }

    public static EntityDrops create(List<LootItemCondition> conditions, ItemLike trophyBase, Map<ResourceLocation, ResourceLocation> trophies, boolean validate) {
        HashSet entities = new HashSet();
        for (ResourceLocation entityTypeId : trophies.keySet()) {
            if (BuiltInRegistries.ENTITY_TYPE.containsKey(entityTypeId) || !validate) {
                entities.add((EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityTypeId));
                continue;
            }
            Trofers.LOGGER.error("Skipping entity trophy drops entry for missing entity '%s'".formatted(entityTypeId));
        }
        return new EntityDrops(conditions, trophyBase.asItem(), trophies, entities);
    }

    public void apply(Consumer<ItemStack> generatedLoot, LootContext context) {
        if (this.matchesConditions(context)) {
            this.doApply(generatedLoot, context);
        }
    }

    private void doApply(Consumer<ItemStack> generatedLoot, LootContext context) {
        EntityType entityType;
        if (context.hasParam(LootContextParams.THIS_ENTITY) && this.entities.contains(entityType = ((Entity)context.getParam(LootContextParams.THIS_ENTITY)).getType())) {
            ResourceLocation trophyId = this.trophies.get(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityType));
            this.awardTrophy(trophyId, generatedLoot);
        }
    }
}

