/*
 * Decompiled with CFR 0.152.
 */
package trofers.item;

import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import trofers.block.TrophyBlock;
import trofers.block.entity.TrophyBlockEntity;
import trofers.trophy.Trophy;

public class TrophyItem
extends BlockItem {
    public TrophyItem(TrophyBlock block, Item.Properties properties) {
        super((Block)block, properties);
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        if (super.placeBlock(context, state)) {
            BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
            if (blockEntity instanceof TrophyBlockEntity) {
                TrophyBlockEntity trophy = (TrophyBlockEntity)blockEntity;
                if (!context.getItemInHand().isEmpty()) {
                    trophy.applyComponentsFromItemStack(context.getItemInHand());
                    Player player = context.getPlayer();
                    if (player instanceof ServerPlayer) {
                        ServerPlayer player2 = (ServerPlayer)player;
                        trophy.resetRewardCooldown(player2);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public Component getName(ItemStack stack) {
        Trophy trophy = Trophy.getTrophy(stack);
        if (trophy != null && trophy.name().isPresent()) {
            return trophy.name().get();
        }
        return super.getName(stack);
    }
}

