/*
 * Decompiled with CFR 0.152.
 */
package trofers.neoforge;

import java.util.function.Supplier;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import trofers.TrofersClient;
import trofers.block.entity.TrophyBlockEntityRenderer;
import trofers.registry.ModBlockEntityTypes;
import trofers.registry.ModBlocks;
import trofers.trophy.TrophySearchTreeManager;

public class TrofersNeoForgeClient {
    public TrofersNeoForgeClient(IEventBus modBus) {
        modBus.addListener(this::onClientSetup);
        modBus.addListener(this::onBlockColorHandler);
        modBus.addListener(this::onItemColorHandler);
        modBus.addListener(this::onRegisterClientReloadListeners);
    }

    public void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)ModBlockEntityTypes.TROPHY.get()), TrophyBlockEntityRenderer::new));
    }

    public void onRegisterClientReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new TrophySearchTreeManager());
    }

    public void onBlockColorHandler(RegisterColorHandlersEvent.Block event) {
        for (Supplier supplier : ModBlocks.TROPHIES) {
            event.register(TrofersClient::getTrophyBlockColor, new Block[]{(Block)supplier.get()});
        }
    }

    public void onItemColorHandler(RegisterColorHandlersEvent.Item event) {
        for (Supplier supplier : ModBlocks.TROPHIES) {
            event.register(TrofersClient::getTrophyItemColor, new ItemLike[]{(ItemLike)supplier.get()});
        }
    }
}

