/*
 * Decompiled with CFR 0.152.
 */
package trofers.neoforge.datagen.providers;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import trofers.data.AdvancementDrops;
import trofers.data.EntityDrops;
import trofers.loot.AdvancementDropsEnabledCondition;
import trofers.loot.RandomTrophyChanceCondition;
import trofers.neoforge.datagen.providers.TrophyProviders;
import trofers.neoforge.datagen.providers.trophies.EntityTrophyProvider;
import trofers.registry.ModBlocks;
import trofers.registry.ModRegistries;
import trofers.util.ConditionsHelper;

public class TrophyDropsProvider
implements DataProvider {
    private final PackOutput packOutput;
    private final Map<String, JsonElement> entityDropsToSerialize = new HashMap<String, JsonElement>();
    private final Map<String, JsonElement> advancementDropsToSerialize = new HashMap<String, JsonElement>();
    private final TrophyProviders trophyProviders;

    public TrophyDropsProvider(PackOutput packOutput, TrophyProviders trophyProviders) {
        this.trophyProviders = trophyProviders;
        this.packOutput = packOutput;
    }

    private void start() {
        List<LootItemCondition> conditions;
        HashMap<String, Map<ResourceLocation, ResourceLocation>> entityDropsMap = new HashMap<String, Map<ResourceLocation, ResourceLocation>>();
        HashMap<String, Map<ResourceLocation, ResourceLocation>> advancementDropsMap = new HashMap<String, Map<ResourceLocation, ResourceLocation>>();
        for (EntityTrophyProvider provider : this.trophyProviders.entityTrophies) {
            entityDropsMap.put(provider.getModId(), provider.getEntityDrops());
            advancementDropsMap.put(provider.getModId(), provider.getAdvancementDrops());
        }
        for (EntityTrophyProvider provider : this.trophyProviders.entityTrophies) {
            provider.addExtraEntityDrops(entityDropsMap);
        }
        for (String modId : entityDropsMap.keySet()) {
            if (((Map)entityDropsMap.get(modId)).isEmpty()) continue;
            conditions = List.of(LootItemKilledByPlayerCondition.killedByPlayer().build(), RandomTrophyChanceCondition.randomTrophyChance().build());
            this.addEntityDrops(modId, EntityDrops.create(conditions, (ItemLike)ModBlocks.SMALL_PLATE.get(), (Map)entityDropsMap.get(modId), false));
        }
        for (String modId : advancementDropsMap.keySet()) {
            if (((Map)advancementDropsMap.get(modId)).isEmpty()) continue;
            conditions = List.of(AdvancementDropsEnabledCondition.advancementDropsEnabled().build());
            this.addAdvancementDrops(modId, new AdvancementDrops(conditions, (ItemLike)ModBlocks.SMALL_PLATE.get(), (Map)advancementDropsMap.get(modId)));
        }
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        this.start();
        Path entityDropsPath = this.packOutput.getOutputFolder(PackOutput.Target.DATA_PACK).resolve("trofers").resolve(ModRegistries.ENTITY_DROPS.location().toString().replace(':', '/'));
        Path advancementDropsPath = this.packOutput.getOutputFolder(PackOutput.Target.DATA_PACK).resolve("trofers").resolve(ModRegistries.ADVANCEMENT_DROPS.location().toString().replace(':', '/'));
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        this.entityDropsToSerialize.forEach((name, json) -> futuresBuilder.add((Object)DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)entityDropsPath.resolve(name + ".json"))));
        this.advancementDropsToSerialize.forEach((name, json) -> futuresBuilder.add((Object)DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)advancementDropsPath.resolve(name + ".json"))));
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }

    private void addEntityDrops(String modId, EntityDrops instance) {
        JsonObject object = ((JsonElement)EntityDrops.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)instance).getOrThrow()).getAsJsonObject();
        if (!modId.equals("minecraft")) {
            ConditionsHelper.addModLoadedConditions(object, modId);
        }
        String name = "%s_trophies".formatted(modId.equals("minecraft") ? "vanilla" : modId);
        this.entityDropsToSerialize.put(name, (JsonElement)object);
    }

    private void addAdvancementDrops(String modId, AdvancementDrops instance) {
        JsonObject object = ((JsonElement)AdvancementDrops.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)instance).getOrThrow()).getAsJsonObject();
        if (!modId.equals("minecraft")) {
            ConditionsHelper.addModLoadedConditions(object, modId);
        }
        String name = "%s_trophies".formatted(modId.equals("minecraft") ? "vanilla" : modId);
        this.advancementDropsToSerialize.put(name, (JsonElement)object);
    }

    public String getName() {
        return "Trophy Drops";
    }
}

