/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.GroupBehaviour;
import net.tslat.smartbrainlib.object.SBLShufflingList;
import org.jetbrains.annotations.Nullable;

public final class SequentialBehaviour<E extends LivingEntity>
extends GroupBehaviour<E> {
    private Predicate<ExtendedBehaviour<? super E>> earlyResetPredicate = behaviour -> false;
    private int runningIndex = 0;

    @SafeVarargs
    public SequentialBehaviour(Pair<ExtendedBehaviour<? super E>, Integer> ... behaviours) {
        super(behaviours);
    }

    @SafeVarargs
    public SequentialBehaviour(ExtendedBehaviour<? super E> ... behaviours) {
        super(behaviours);
    }

    public SequentialBehaviour(List<Pair<ExtendedBehaviour<? super E>, Integer>> behaviours) {
        super(behaviours);
    }

    public SequentialBehaviour<E> resetIf(Predicate<ExtendedBehaviour<? super E>> predicate) {
        this.earlyResetPredicate = predicate;
        return this;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return this.runningBehaviour != null && this.runningBehaviour.getStatus() != Behavior.Status.STOPPED;
    }

    @Override
    protected boolean timedOut(long gameTime) {
        return this.runningBehaviour == null || this.runningBehaviour.timedOut(gameTime) && this.runningIndex >= this.behaviours.size();
    }

    @Override
    protected void tick(ServerLevel level, E owner, long gameTime) {
        this.runningBehaviour.tickOrStop(level, (LivingEntity)owner, gameTime);
        if (this.runningBehaviour.getStatus() == Behavior.Status.STOPPED) {
            if (this.pickBehaviour(level, owner, gameTime, this.behaviours) != null) {
                return;
            }
            this.doStop(level, (LivingEntity)owner, gameTime);
        }
    }

    @Override
    @Nullable
    protected ExtendedBehaviour<? super E> pickBehaviour(ServerLevel level, E entity, long gameTime, SBLShufflingList<ExtendedBehaviour<? super E>> extendedBehaviours) {
        if (this.runningIndex >= extendedBehaviours.size()) {
            return null;
        }
        ExtendedBehaviour<E> next = extendedBehaviours.get(this.runningIndex);
        if (next != null) {
            if (this.runningBehaviour != null && this.earlyResetPredicate.test(next)) {
                return null;
            }
            if (next.tryStart(level, entity, gameTime)) {
                this.runningBehaviour = next;
                ++this.runningIndex;
                return this.runningBehaviour;
            }
        }
        return null;
    }

    @Override
    protected void stop(ServerLevel level, E entity, long gameTime) {
        super.stop(level, entity, gameTime);
        this.runningIndex = 0;
    }
}

