/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.mixin.core;

import com.pedrorok.hypertube.mixin.core.PlayerModelAccessor;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidModel.class}, priority=1001)
public abstract class PlayerModelMixin {
    @Inject(method={"setupAnim*"}, at={@At(value="RETURN")}, cancellable=true, order=1001)
    private void createHypertube$onSetupAnim(LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (!entity.getPersistentData().getBoolean("hypertube_travel")) {
            return;
        }
        HumanoidModel model = (HumanoidModel)this;
        boolean isPlayerModel = model instanceof PlayerModel;
        PlayerModel playerModel = isPlayerModel ? (PlayerModel)model : null;
        model.rightArm.xRot = 0.0f;
        model.rightArm.yRot = 0.0f;
        model.rightArm.zRot = 0.0f;
        model.leftArm.xRot = 0.0f;
        model.leftArm.yRot = 0.0f;
        model.leftArm.zRot = 0.0f;
        model.rightLeg.xRot = 0.0f;
        model.rightLeg.yRot = 0.0f;
        model.rightLeg.zRot = 0.0f;
        model.leftLeg.xRot = 0.0f;
        model.leftLeg.yRot = 0.0f;
        model.leftLeg.zRot = 0.0f;
        model.body.xRot = 0.0f;
        model.body.yRot = 0.0f;
        model.body.zRot = 0.0f;
        model.head.xRot = -1.2f;
        model.head.yRot = 0.0f;
        model.head.zRot = 0.0f;
        model.hat.xRot = -1.2f;
        model.hat.yRot = 0.0f;
        model.hat.zRot = 0.0f;
        if (isPlayerModel) {
            playerModel.rightSleeve.xRot = 0.0f;
            playerModel.rightSleeve.yRot = 0.0f;
            playerModel.rightSleeve.zRot = 0.0f;
            playerModel.leftSleeve.xRot = 0.0f;
            playerModel.leftSleeve.yRot = 0.0f;
            playerModel.leftSleeve.zRot = 0.0f;
            playerModel.rightPants.xRot = 0.0f;
            playerModel.rightPants.yRot = 0.0f;
            playerModel.rightPants.zRot = 0.0f;
            playerModel.leftPants.xRot = 0.0f;
            playerModel.leftPants.yRot = 0.0f;
            playerModel.leftPants.zRot = 0.0f;
            playerModel.jacket.xRot = 0.0f;
            playerModel.jacket.yRot = 0.0f;
            playerModel.jacket.zRot = 0.0f;
            PlayerModelAccessor accessor = (PlayerModelAccessor)playerModel;
            ModelPart cloak = accessor.createHypertube$getCloak();
            cloak.visible = false;
        }
        ci.cancel();
    }
}

