/*
 * Decompiled with CFR 0.152.
 */
package fox.mods.foxs_core;

import fox.mods.foxs_core.network.FoxsCoreModVariables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="foxs_core")
public class FoxsCore {
    public static final Logger LOGGER = LogManager.getLogger(FoxsCore.class);
    public static final String MODID = "foxs_core";
    public static final double COUNTDOWN_TICKS = 0.05;
    public static final List<Block> signBlocks = List.of(Blocks.OAK_SIGN, Blocks.SPRUCE_SIGN, Blocks.BIRCH_SIGN, Blocks.ACACIA_SIGN, Blocks.JUNGLE_SIGN, Blocks.DARK_OAK_SIGN, Blocks.CRIMSON_SIGN, Blocks.WARPED_SIGN, Blocks.MANGROVE_SIGN, Blocks.CHERRY_SIGN, Blocks.BAMBOO_SIGN, Blocks.OAK_WALL_SIGN, Blocks.SPRUCE_WALL_SIGN, Blocks.BIRCH_WALL_SIGN, Blocks.ACACIA_WALL_SIGN, Blocks.JUNGLE_WALL_SIGN, Blocks.DARK_OAK_WALL_SIGN, Blocks.CRIMSON_WALL_SIGN, Blocks.WARPED_WALL_SIGN, Blocks.MANGROVE_WALL_SIGN, Blocks.CHERRY_WALL_SIGN, Blocks.BAMBOO_WALL_SIGN, Blocks.OAK_HANGING_SIGN, Blocks.SPRUCE_HANGING_SIGN, Blocks.BIRCH_HANGING_SIGN, Blocks.ACACIA_HANGING_SIGN, Blocks.JUNGLE_HANGING_SIGN, Blocks.DARK_OAK_HANGING_SIGN, Blocks.CRIMSON_HANGING_SIGN, Blocks.WARPED_HANGING_SIGN, Blocks.MANGROVE_HANGING_SIGN, Blocks.CHERRY_HANGING_SIGN, Blocks.BAMBOO_HANGING_SIGN, Blocks.OAK_WALL_HANGING_SIGN, Blocks.SPRUCE_WALL_HANGING_SIGN, Blocks.BIRCH_WALL_HANGING_SIGN, Blocks.ACACIA_WALL_HANGING_SIGN, Blocks.JUNGLE_WALL_HANGING_SIGN, Blocks.DARK_OAK_WALL_HANGING_SIGN, Blocks.CRIMSON_WALL_HANGING_SIGN, Blocks.WARPED_WALL_HANGING_SIGN, Blocks.MANGROVE_WALL_HANGING_SIGN, Blocks.CHERRY_WALL_HANGING_SIGN, Blocks.BAMBOO_WALL_HANGING_SIGN);
    private static boolean networkingRegistered = false;
    private static final Map<CustomPacketPayload.Type<?>, NetworkMessage<?>> MESSAGES = new HashMap();
    private static final Collection<Tuple<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<Tuple<Runnable, Integer>>();

    public FoxsCore(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::registerNetworking);
        FoxsCoreModVariables.ATTACHMENT_TYPES.register(modEventBus);
    }

    public static <T extends CustomPacketPayload> void addNetworkMessage(CustomPacketPayload.Type<T> id, StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
        if (networkingRegistered) {
            throw new IllegalStateException("Cannot register new network messages after networking has been registered");
        }
        MESSAGES.put(id, new NetworkMessage<T>(reader, handler));
    }

    private void registerNetworking(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID);
        MESSAGES.forEach((id, networkMessage) -> registrar.playBidirectional(id, networkMessage.reader(), networkMessage.handler()));
        networkingRegistered = true;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add((Tuple<Runnable, Integer>)new Tuple((Object)action, (Object)tick));
        }
    }

    @SubscribeEvent
    public void tick(ServerTickEvent.Post event) {
        ArrayList actions = new ArrayList();
        workQueue.forEach(work -> {
            work.setB((Object)((Integer)work.getB() - 1));
            if ((Integer)work.getB() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getA()).run());
        workQueue.removeAll(actions);
    }

    public static void mutePlayer(Player player, double seconds) {
        boolean muted = ((FoxsCoreModVariables.PlayerVariables)player.getData(FoxsCoreModVariables.PLAYER_VARIABLES)).muted;
        if (muted) {
            return;
        }
        FoxsCoreModVariables.PlayerVariables _vars = (FoxsCoreModVariables.PlayerVariables)player.getData(FoxsCoreModVariables.PLAYER_VARIABLES);
        _vars.muted = true;
        _vars.syncPlayerVariables((Entity)player);
        _vars = (FoxsCoreModVariables.PlayerVariables)player.getData(FoxsCoreModVariables.PLAYER_VARIABLES);
        _vars.muteDuration = seconds;
        _vars.syncPlayerVariables((Entity)player);
    }

    public static void mutePlayer(Player player) {
        boolean muted = ((FoxsCoreModVariables.PlayerVariables)player.getData(FoxsCoreModVariables.PLAYER_VARIABLES)).muted;
        if (muted) {
            return;
        }
        FoxsCoreModVariables.PlayerVariables _vars = (FoxsCoreModVariables.PlayerVariables)player.getData(FoxsCoreModVariables.PLAYER_VARIABLES);
        _vars.muted = true;
        _vars.syncPlayerVariables((Entity)player);
    }

    public static void unmutePlayer(Player player) {
        boolean muted = ((FoxsCoreModVariables.PlayerVariables)player.getData(FoxsCoreModVariables.PLAYER_VARIABLES)).muted;
        if (!muted) {
            return;
        }
        FoxsCoreModVariables.PlayerVariables _vars = (FoxsCoreModVariables.PlayerVariables)player.getData(FoxsCoreModVariables.PLAYER_VARIABLES);
        _vars.muted = false;
        _vars.syncPlayerVariables((Entity)player);
    }

    public static void cancelEvent(Event event) {
        if (event instanceof ICancellableEvent) {
            ICancellableEvent _cancellable = (ICancellableEvent)event;
            _cancellable.setCanceled(true);
        }
    }

    public static boolean isSign(Block block) {
        return signBlocks.contains(block);
    }

    public static boolean checkEntityExistence(Entity entity) {
        return entity != null;
    }

    public static void addEffectToEntity(Player player, Holder<MobEffect> mobEffect, int duration, int amplifier, boolean ambientParticles, boolean visible) {
        Player _entity;
        if (player instanceof LivingEntity && !(_entity = player).level().isClientSide()) {
            _entity.addEffect(new MobEffectInstance(mobEffect, duration, amplifier, ambientParticles, visible));
        }
    }

    public static boolean areEntitiesColliding(Entity entity1, Entity entity2) {
        return entity1.getBoundingBox().intersects(entity2.getBoundingBox());
    }

    public static Entity findEntityInWorldRange(LevelAccessor world, Class<? extends Entity> clazz, double x, double y, double z, double range) {
        return world.getEntitiesOfClass(clazz, AABB.ofSize((Vec3)new Vec3(x, y, z), (double)range, (double)range, (double)range), e -> true).stream().sorted(Comparator.comparingDouble(e -> e.distanceToSqr(x, y, z))).findFirst().orElse(null);
    }

    public static void changeEntityDimensionToCustom(Player player, String resourceLocation) {
        ServerPlayer _player;
        if (player instanceof ServerPlayer && !(_player = (ServerPlayer)player).level().isClientSide()) {
            ResourceKey destinationType = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)resourceLocation));
            if (_player.level().dimension() == destinationType) {
                return;
            }
            ServerLevel nextLevel = _player.server.getLevel(destinationType);
            if (nextLevel != null) {
                _player.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.WIN_GAME, 0.0f));
                _player.teleportTo(nextLevel, _player.getX(), _player.getY(), _player.getZ(), Set.of(), _player.getYRot(), _player.getXRot(), true);
                _player.connection.send((Packet)new ClientboundPlayerAbilitiesPacket(_player.getAbilities()));
                for (MobEffectInstance _effectinstance : _player.getActiveEffects()) {
                    _player.connection.send((Packet)new ClientboundUpdateMobEffectPacket(_player.getId(), _effectinstance, false));
                }
                _player.connection.send((Packet)new ClientboundLevelEventPacket(1032, BlockPos.ZERO, 0, false));
            }
        }
    }

    public static void changeEntityDimensionToVanilla(Player player, ResourceKey<Level> dimension) {
        ServerPlayer _player;
        if (player instanceof ServerPlayer && !(_player = (ServerPlayer)player).level().isClientSide()) {
            ResourceKey<Level> destinationType = dimension;
            if (_player.level().dimension() == destinationType) {
                return;
            }
            ServerLevel nextLevel = _player.server.getLevel(destinationType);
            if (nextLevel != null) {
                _player.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.WIN_GAME, 0.0f));
                _player.teleportTo(nextLevel, _player.getX(), _player.getY(), _player.getZ(), Set.of(), _player.getYRot(), _player.getXRot(), true);
                _player.connection.send((Packet)new ClientboundPlayerAbilitiesPacket(_player.getAbilities()));
                for (MobEffectInstance _effectinstance : _player.getActiveEffects()) {
                    _player.connection.send((Packet)new ClientboundUpdateMobEffectPacket(_player.getId(), _effectinstance, false));
                }
                _player.connection.send((Packet)new ClientboundLevelEventPacket(1032, BlockPos.ZERO, 0, false));
            }
        }
    }

    public static void teleportEntityTo(Player player, double x, double y, double z) {
        player.teleportTo(x, y, z);
        if (player instanceof ServerPlayer) {
            ServerPlayer _serverPlayer = (ServerPlayer)player;
            _serverPlayer.connection.teleport(x, y, z, player.getYRot(), player.getXRot());
        }
    }

    public static void spawnCircleParticles(Entity player, Level level, ParticleOptions particleType, int particleCount, double radius) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double playerX = player.getX();
        double playerY = player.getY() + 1.5;
        double playerZ = player.getZ();
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            double x = playerX + radius * Math.cos(angle);
            double z = playerZ + radius * Math.sin(angle);
            serverLevel.sendParticles(particleType, x, playerY, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnSphereParticles(Entity player, Level level, ParticleOptions particleType, int particleCount, double radius) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double playerX = player.getX();
        double playerY = player.getY() + 1.0;
        double playerZ = player.getZ();
        for (int i = 0; i < particleCount; ++i) {
            double theta = Math.random() * 2.0 * Math.PI;
            double phi = Math.acos(2.0 * Math.random() - 1.0);
            double offsetX = radius * Math.sin(phi) * Math.cos(theta);
            double offsetY = radius * Math.cos(phi);
            double offsetZ = radius * Math.sin(phi) * Math.sin(theta);
            double x = playerX + offsetX;
            double y = playerY + offsetY;
            double z = playerZ + offsetZ;
            serverLevel.sendParticles(particleType, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnBlockBreakParticles(Level level, BlockPos pos, BlockState blockState) {
        if (!level.isClientSide()) {
            return;
        }
        level.levelEvent(2001, pos, Block.getId((BlockState)blockState));
    }

    public static void spawnSwirlParticles(Entity player, ParticleOptions particleType) {
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double centerX = player.getX();
        double centerY = player.getY();
        double centerZ = player.getZ();
        double radius = 1.0;
        int heightSteps = 20;
        int particlesPerStep = 20;
        for (int step = 0; step < heightSteps; ++step) {
            double height = centerY + (double)step / (double)heightSteps * 2.0;
            for (int i = 0; i < particlesPerStep; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)particlesPerStep;
                double offsetX = radius * Math.cos(angle + (double)step * 0.1);
                double offsetZ = radius * Math.sin(angle + (double)step * 0.1);
                serverLevel.sendParticles(particleType, centerX + offsetX, height, centerZ + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void spawnFallCircleParticles(Entity player, Level level, ParticleOptions particleType, int particleCount, double radius) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double playerX = player.getX();
        double playerY = player.getY();
        double playerZ = player.getZ();
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            double x = playerX + radius * Math.cos(angle);
            double z = playerZ + radius * Math.sin(angle);
            serverLevel.sendParticles(particleType, x, playerY, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnFallCircleDustParticles(Entity player, Level level, DustParticleOptions particleType, int particleCount, double radius) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double playerX = player.getX();
        double playerY = player.getY() + 1.0;
        double playerZ = player.getZ();
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            double x = playerX + radius * Math.cos(angle);
            double z = playerZ + radius * Math.sin(angle);
            serverLevel.sendParticles((ParticleOptions)particleType, x, playerY, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnFootCircleParticles(Entity player, Level level, ParticleOptions particleType, int particleCount, double radius) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double playerX = player.getX();
        double playerY = player.getY();
        double playerZ = player.getZ();
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            double x = playerX + radius * Math.cos(angle);
            double z = playerZ + radius * Math.sin(angle);
            serverLevel.sendParticles(particleType, x, playerY, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void executeCommand(LevelAccessor world, String command) {
        if (world instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)world;
            _level.getServer().getCommands().performPrefixedCommand(new CommandSourceStack(CommandSource.NULL, new Vec3(0.0, 0.0, 0.0), Vec2.ZERO, _level, 4, "", (Component)Component.literal((String)""), _level.getServer(), null).withSuppressedOutput(), command);
        }
    }

    public static int calculatePotionLevel(int desiredEffectLevel) {
        return desiredEffectLevel / 2;
    }

    public static String getBlockNBTString(LevelAccessor world, BlockPos pos, String tag) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity != null) {
            return blockEntity.getPersistentData().getString(tag);
        }
        return "";
    }

    public static double getBlockNBTNumber(LevelAccessor world, BlockPos pos, String tag) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity != null) {
            return blockEntity.getPersistentData().getDouble(tag);
        }
        return 0.0;
    }

    public static void kickPlayer(Player player, String reason) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MutableComponent message = Component.literal((String)reason);
            serverPlayer.connection.disconnect((Component)message);
        }
    }

    public static void banPlayer(Player player, String reason) {
        Level level = player.level();
        if (level instanceof ServerLevel) {
            ServerLevel _level = (ServerLevel)level;
            FoxsCore.executeCommand((LevelAccessor)player.level(), "ban " + player.getName().getString() + " " + reason);
        }
    }

    private record NetworkMessage<T extends CustomPacketPayload>(StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
    }
}

