/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.config;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import me.fzzyhmstrs.fzzy_config.annotations.Action;
import me.fzzyhmstrs.fzzy_config.annotations.RequiresAction;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import me.fzzyhmstrs.fzzy_config.config.Config;
import me.fzzyhmstrs.fzzy_config.entry.Entry;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedIdentifierMap;
import me.fzzyhmstrs.fzzy_config.validation.collection.ValidatedSet;
import me.fzzyhmstrs.fzzy_config.validation.minecraft.ValidatedIdentifier;
import me.fzzyhmstrs.fzzy_config.validation.minecraft.ValidatedRegistryType;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedBoolean;
import me.fzzyhmstrs.fzzy_config.validation.misc.ValidatedCondition;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.TagRegistry;

@RequiresAction(action=Action.RELOAD_DATA)
public class LootConfig
extends Config {
    public static final LootConfig INSTANCE = (LootConfig)ConfigApiJava.registerAndLoadConfig(LootConfig::new);
    public ValidatedBoolean enableLootDrops = new ValidatedBoolean(true);
    public ValidatedBoolean enableLootInVillages = new ValidatedBoolean(false);
    public ValidatedFloat standardLootTableWeight = new ValidatedFloat(0.1f, 100.0f, 0.0f);
    public ValidatedFloat rareLootTableWeight = new ValidatedFloat(0.4f, 100.0f, 0.0f);
    public ValidatedFloat runicLootTableWeight = new ValidatedFloat(0.7f, 100.0f, 0.0f);
    public ValidatedFloat uniqueLootTableWeight = new ValidatedFloat(0.3f, 100.0f, 0.0f);
    public ValidatedCondition<Boolean> enableContainedRemnants = new ValidatedBoolean().toCondition(() -> ((Float)this.uniqueLootTableWeight.get()).floatValue() > 0.0f, (Component)Component.translatable((String)"simplyswords.loot.enableContainedRemnants.condition"), () -> false).withFailTitle((Component)Component.translatable((String)"simplyswords.loot.enableContainedRemnants.failTitle"));
    public ValidatedIdentifierMap<Float> uniqueLootTableOptions = new ValidatedIdentifierMap.Builder().keyHandler(ValidatedIdentifier.ofDynamicKey((ResourceLocation)BuiltInLootTables.END_CITY_TREASURE.location(), (ResourceKey)Registries.LOOT_TABLE, (String)"simplyswords_no_blocks", (id, e) -> ((LootTable)e.value()).getParamSet() != LootContextParamSets.BLOCK)).valueHandler((Entry)new ValidatedFloat(0.1f, 100.0f, 0.0f)).defaults((Map)ImmutableMap.builder().put((Object)ResourceLocation.withDefaultNamespace((String)"entities/wither"), (Object)Float.valueOf(5.0f)).put((Object)ResourceLocation.withDefaultNamespace((String)"entities/ender_dragon"), (Object)Float.valueOf(50.0f)).put((Object)ResourceLocation.withDefaultNamespace((String)"chests/ruined_portal"), (Object)Float.valueOf(0.0f)).put((Object)ResourceLocation.withDefaultNamespace((String)"chests/village/village_armorer"), (Object)Float.valueOf(0.0f)).put((Object)ResourceLocation.withDefaultNamespace((String)"chests/village/village_butcher"), (Object)Float.valueOf(0.0f)).put((Object)ResourceLocation.withDefaultNamespace((String)"chests/village/village_cartographer"), (Object)Float.valueOf(0.0f)).put((Object)ResourceLocation.withDefaultNamespace((String)"chests/village/village_desert_house"), (Object)Float.valueOf(0.0f)).put((Object)ResourceLocation.withDefaultNamespace((String)"chests/village/village_fisher"), (Object)Float.valueOf(0.0f)).put((Object)ResourceLocation.withDefaultNamespace((String)"chests/village/village_fletcher"), (Object)Float.valueOf(0.0f)).put((Object)ResourceLocation.withDefaultNamespace((String)"chests/village/village_mason"), (Object)Float.valueOf(0.0f)).put((Object)ResourceLocation.withDefaultNamespace((String)"chests/village/village_plains_house"), (Object)Float.valueOf(0.0f)).put((Object)ResourceLocation.withDefaultNamespace((String)"chests/village/village_savanna_house"), (Object)Float.valueOf(0.0f)).put((Object)ResourceLocation.withDefaultNamespace((String)"chests/village/village_shepherd"), (Object)Float.valueOf(0.0f)).put((Object)ResourceLocation.withDefaultNamespace((String)"chests/village/village_snowy_house"), (Object)Float.valueOf(0.0f)).put((Object)ResourceLocation.withDefaultNamespace((String)"chests/village/village_taiga_house"), (Object)Float.valueOf(0.0f)).put((Object)ResourceLocation.withDefaultNamespace((String)"chests/village/village_tannery"), (Object)Float.valueOf(0.0f)).put((Object)ResourceLocation.withDefaultNamespace((String)"chests/village/village_temple"), (Object)Float.valueOf(0.0f)).put((Object)ResourceLocation.withDefaultNamespace((String)"chests/village/village_toolsmith"), (Object)Float.valueOf(0.0f)).put((Object)ResourceLocation.withDefaultNamespace((String)"chests/village/village_weaponsmith"), (Object)Float.valueOf(0.0f)).build()).build();
    public ValidatedSet<Item> disabledUniqueWeaponLoot = ValidatedRegistryType.of((Object)((Item)ItemsRegistry.ARCANETHYST.value()), (Registry)BuiltInRegistries.ITEM, entry -> TagRegistry.isInTag(TagRegistry.lootableUniques, (Item)entry.value())).toSet((Object[])new Item[0]);

    public LootConfig() {
        super(ResourceLocation.fromNamespaceAndPath((String)"simplyswords", (String)"loot"));
    }
}

