/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.config.settings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.TooltipProvider;

public class ItemStackTooltipAppender
implements Supplier<TooltipProvider> {
    private final List<? extends TooltipProvider> appenders;
    private static final ItemAttributeModifiers hider = new ItemAttributeModifiers(new ArrayList(), false);

    @SafeVarargs
    public ItemStackTooltipAppender(Supplier<? extends Item> ... itemStacks) {
        this.appenders = Arrays.stream(itemStacks).map(StackAppender::new).toList();
    }

    @Override
    public TooltipProvider get() {
        long threeSeconds = System.currentTimeMillis() / 3000L;
        return this.appenders.get((int)(threeSeconds % (long)this.appenders.size()));
    }

    private record StackAppender(Supplier<? extends Item> stack) implements TooltipProvider
    {
        public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltip, TooltipFlag type) {
            Item s = this.stack.get();
            if (s == null) {
                return;
            }
            ArrayList list = new ArrayList();
            s.appendHoverText(s.getDefaultInstance(), context, list, type);
            if (!list.isEmpty() && Objects.equals(((Component)list.get(0)).getString(), "")) {
                list.remove(0);
            }
            list.forEach(tooltip);
        }
    }
}

