/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.registry.EffectRegistry;

public class EchoEffect
extends MobEffect {
    public EchoEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.level().isClientSide() && livingEntity.tickCount % 15 == 0) {
            int damage = Config.statusEffects.echoDamage;
            livingEntity.invulnerableTime = 0;
            livingEntity.hurt(livingEntity.damageSources().magic(), (float)(damage + amplifier));
            livingEntity.removeEffect(EffectRegistry.getReference(EffectRegistry.ECHO));
        }
        super.applyEffectTick(livingEntity, amplifier);
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return true;
    }
}

