/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.sweenus.simplyswords.registry.EffectRegistry;

public class OnslaughtEffect
extends MobEffect {
    public OnslaughtEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public boolean applyEffectTick(LivingEntity pLivingEntity, int pAmplifier) {
        if (!pLivingEntity.level().isClientSide() && pLivingEntity instanceof Player) {
            if (pLivingEntity.tickCount % 40 == 0) {
                pLivingEntity.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 10, 15), (Entity)pLivingEntity);
            }
            if (pLivingEntity.tickCount % 65 == 0 && pLivingEntity.hasEffect(MobEffects.DIG_SPEED)) {
                pLivingEntity.removeEffect(MobEffects.DIG_SPEED);
            }
            if (pLivingEntity.hasEffect(EffectRegistry.getReference(EffectRegistry.ONSLAUGHT))) {
                MobEffectInstance statusEffect = pLivingEntity.getEffect(EffectRegistry.getReference(EffectRegistry.ONSLAUGHT));
                assert (statusEffect != null);
                if (statusEffect.getDuration() < 10 && pLivingEntity.hasEffect(MobEffects.DIG_SPEED)) {
                    pLivingEntity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 80, 0), (Entity)pLivingEntity);
                    pLivingEntity.removeEffect(MobEffects.DIG_SPEED);
                    pLivingEntity.removeEffect(EffectRegistry.getReference(EffectRegistry.ONSLAUGHT));
                }
            }
        }
        super.applyEffectTick(pLivingEntity, pAmplifier);
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return true;
    }
}

