/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.effect;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.util.HelperMethods;

public class StormEffect
extends MobEffect {
    public StormEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public boolean applyEffectTick(LivingEntity pLivingEntity, int pAmplifier) {
        if (!pLivingEntity.level().isClientSide()) {
            ServerLevel world = (ServerLevel)pLivingEntity.level();
            double hRadius = Config.uniqueEffects.mjolnir.radius;
            double vRadius = (float)Config.uniqueEffects.mjolnir.radius / 2.0f;
            double x = pLivingEntity.getX();
            double y = pLivingEntity.getY();
            double z = pLivingEntity.getZ();
            LivingEntity pPlayer = pLivingEntity.getLastHurtByMob();
            AABB box = new AABB(x + hRadius, y + vRadius, z + hRadius, x - hRadius, y - vRadius, z - hRadius);
            for (Entity e : world.getEntities((Entity)pPlayer, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                if (!(e instanceof LivingEntity)) continue;
                LivingEntity ee = (LivingEntity)e;
                if (!(pPlayer instanceof Player)) continue;
                Player player = (Player)pPlayer;
                if (!ee.isInWaterOrRain() || !HelperMethods.checkFriendlyFire(ee, (LivingEntity)player)) continue;
                BlockPos stormtarget = ee.blockPosition();
                if (!(ee.distanceTo((Entity)pPlayer) >= 5.0f)) continue;
                Entity entity = EntityType.LIGHTNING_BOLT.spawn(world, stormtarget, MobSpawnType.TRIGGERED);
            }
        }
        super.applyEffectTick(pLivingEntity, pAmplifier);
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return true;
    }
}

