/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.entity.goal;

import java.util.EnumSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class AttackHostileMobsGoal
extends Goal {
    private final PathfinderMob entity;
    private final TargetingConditions hostileMobTargetPredicate;
    private LivingEntity targetMob;
    private Player targetPlayer;
    private final double attackRange;
    private final double playerCheckRange;
    private final double speed;

    public AttackHostileMobsGoal(PathfinderMob entity, double attackRange, double speed, double playerCheckRange) {
        this.entity = entity;
        this.attackRange = attackRange;
        this.speed = speed;
        this.playerCheckRange = playerCheckRange;
        this.hostileMobTargetPredicate = TargetingConditions.forCombat().range(attackRange);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.TARGET));
    }

    public boolean canUse() {
        Level level = this.entity.level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverWorld = (ServerLevel)level;
        this.targetPlayer = serverWorld.getNearestPlayer(this.entity.getX(), this.entity.getY(), this.entity.getZ(), this.playerCheckRange, false);
        if (this.targetPlayer == null) {
            return false;
        }
        this.targetMob = serverWorld.getNearestEntity(Monster.class, this.hostileMobTargetPredicate, (LivingEntity)this.entity, this.entity.getX(), this.entity.getY(), this.entity.getZ(), this.entity.getBoundingBox().inflate(this.attackRange));
        return this.targetMob != null;
    }

    public boolean canContinueToUse() {
        return this.targetMob != null && this.targetMob.isAlive() && this.targetPlayer != null && this.entity.distanceToSqr((Entity)this.targetPlayer) <= this.playerCheckRange * this.playerCheckRange;
    }

    public void stop() {
        this.targetMob = null;
        this.entity.getNavigation().stop();
    }

    public void tick() {
        if (this.targetMob != null) {
            this.entity.getNavigation().moveTo(this.targetMob.getX(), this.targetMob.getY(), this.targetMob.getZ(), this.speed);
            this.entity.getLookControl().setLookAt((Entity)this.targetMob, 30.0f, 30.0f);
            if (this.entity.distanceToSqr((Entity)this.targetMob) <= 4.0 && this.targetMob.invulnerableTime < 10) {
                this.entity.doHurtTarget((Entity)this.targetMob);
            }
        }
    }
}

