/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.sweenus.simplyswords.SimplySwords;
import net.sweenus.simplyswords.client.api.SimplySwordsClientAPI;
import net.sweenus.simplyswords.config.LootConfig;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class ContainedRemnantItem
extends Item {
    private static final int checkRadius = 10;
    private static final int itemCooldown = 140;
    private static final Map<UUID, Long> playerInternalCooldowns = new HashMap<UUID, Long>();
    private static final Map<Block, ResourceLocation> transformationMap = new HashMap<Block, ResourceLocation>();

    public ContainedRemnantItem() {
        super(new Item.Properties().arch$tab(SimplySwords.SIMPLYSWORDS).rarity(Rarity.EPIC).fireResistant().stacksTo(1));
    }

    public static void addTransformation(Block block, ResourceLocation identifier) {
        transformationMap.put(block, identifier);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockState blockState = context.getLevel().getBlockState(context.getClickedPos());
        Player player = context.getPlayer();
        ItemStack heldStack = context.getItemInHand();
        if (player != null && !player.level().isClientSide) {
            ServerLevel serverWorld = (ServerLevel)player.level();
            if (!ItemsRegistry.ITEM.getRegistrar().contains(transformationMap.get(blockState.getBlock()))) {
                return InteractionResult.PASS;
            }
            Item transformedItem = (Item)ItemsRegistry.ITEM.getRegistrar().get(transformationMap.get(blockState.getBlock()));
            if (transformedItem != null) {
                if (LootConfig.INSTANCE.disabledUniqueWeaponLoot.contains((Object)transformedItem)) {
                    return InteractionResult.PASS;
                }
                ItemStack newItem = new ItemStack((ItemLike)transformedItem);
                heldStack.shrink(1);
                HelperMethods.spawnOrbitParticles(serverWorld, player.position(), (ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, 1.0, 6);
                player.level().playSound(null, player.blockPosition(), (SoundEvent)SoundRegistry.DARK_ACTIVATION_DISTORTED.get(), player.getSoundSource(), 0.4f, 1.8f);
                player.drop(newItem, false);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)this.getDescriptionId(stack)).setStyle(Styles.LEGENDARY);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.contained_remnant_description").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.contained_remnant_description2").withStyle(ChatFormatting.GRAY));
        if (((Object)((Object)this)).equals(ItemsRegistry.TAMPERED_REMNANT.get())) {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.tampered_remnant_description3").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.tampered_remnant_description4").withStyle(ChatFormatting.GRAY));
        } else {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.contained_remnant_description3").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.contained_remnant_description4").withStyle(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.contained_remnant_description5").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.contained_remnant_description6").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.literal((String)""));
        this.generateDynamicTooltip(itemStack, tooltipContext, tooltip, type);
        if (this.asItem().equals(ItemsRegistry.CONTAINED_REMNANT.get()) && Screen.hasAltDown()) {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.contained_remnant_description7").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.contained_remnant_description8").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.contained_remnant_description9").withStyle(ChatFormatting.GRAY));
        }
    }

    protected void generateDynamicTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        SimplySwordsClientAPI.generateDynamicTooltip(itemStack, tooltipContext, tooltip, type, "simplyswords", "oracle_index:books/simplyswords/weapon-types", "oracle_index:books/simplyswords/unique-weapons", "oracle_index:books/simplyswords/runic-powers", null);
    }

    public static void checkNearbyBlocks(ServerPlayer player) {
        UUID playerId;
        long lastTick;
        Level world = player.level();
        if (world.isClientSide) {
            return;
        }
        long currentTick = world.getGameTime();
        if (currentTick - (lastTick = playerInternalCooldowns.getOrDefault(playerId = player.getUUID(), 0L).longValue()) < 140L) {
            return;
        }
        BlockPos playerPos = player.blockPosition();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = -10; x <= 10; ++x) {
            for (int y = -10; y <= 10; ++y) {
                for (int z = -10; z <= 10; ++z) {
                    mutablePos.set(playerPos.getX() + x, playerPos.getY() + y, playerPos.getZ() + z);
                    Block block = world.getBlockState((BlockPos)mutablePos).getBlock();
                    if (!transformationMap.containsKey(block)) continue;
                    player.displayClientMessage((Component)Component.translatable((String)"item.simplyswords.contained_remnant.event3"), true);
                    HelperMethods.spawnParticlesBetween(player, (BlockPos)mutablePos, (ServerLevel)world, (ParticleOptions)ParticleTypes.ENCHANT, 20);
                    player.level().playSound(null, (BlockPos)mutablePos, (SoundEvent)SoundRegistry.DARK_ACTIVATION_DISTORTED.get(), player.getSoundSource(), 0.1f, 1.2f);
                    playerInternalCooldowns.put(playerId, currentTick);
                    return;
                }
            }
        }
    }
}

