/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.component;

import com.mojang.serialization.Codec;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record StoredChargeComponent(int charge) {
    public static StoredChargeComponent DEFAULT = new StoredChargeComponent(0);
    public static Codec<StoredChargeComponent> CODEC = Codec.INT.xmap(StoredChargeComponent::new, StoredChargeComponent::charge);
    public static StreamCodec<RegistryFriendlyByteBuf, StoredChargeComponent> PACKET_CODEC = ByteBufCodecs.INT.map(StoredChargeComponent::new, StoredChargeComponent::charge).cast();

    public StoredChargeComponent add(int addedCharge) {
        return new StoredChargeComponent(this.charge + addedCharge);
    }

    public StoredChargeComponent increment() {
        return new StoredChargeComponent(this.charge + 1);
    }

    public StoredChargeComponent decrement() {
        return new StoredChargeComponent(Math.max(0, this.charge - 1));
    }

    public StoredChargeComponent set(int newCharge) {
        return new StoredChargeComponent(newCharge);
    }
}

