/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.item.TwoHandedWeapon;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class BrimstoneClaymoreItem
extends UniqueSwordItem
implements TwoHandedWeapon {
    public BrimstoneClaymoreItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            ServerLevel world = (ServerLevel)attacker.level();
            int fhitchance = Config.uniqueEffects.brimstone_claymore.chance;
            HelperMethods.playHitSounds(attacker, target);
            if (attacker.getRandom().nextInt(100) <= fhitchance && attacker instanceof Player) {
                Player player = (Player)attacker;
                int choose_sound = (int)(Math.random() * 3.0);
                List<LivingEntity> nearbyEntities = HelperMethods.getNearbyLivingEntities((Level)world, target.position(), 3.0);
                DamageSource damageSource = player.damageSources().indirectMagic((Entity)player, (Entity)player);
                for (LivingEntity livingEntity : nearbyEntities) {
                    if (!HelperMethods.checkFriendlyFire(livingEntity, attacker)) continue;
                    HelperMethods.spawnWaistHeightParticles(world, (ParticleOptions)ParticleTypes.LAVA, (Entity)attacker, (Entity)target, 3);
                    HelperMethods.spawnOrbitParticles(world, livingEntity.position(), (ParticleOptions)ParticleTypes.LAVA, 1.0, 3);
                    HelperMethods.spawnOrbitParticles(world, livingEntity.position(), (ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, 2.0, 6);
                    HelperMethods.spawnOrbitParticles(world, livingEntity.position(), (ParticleOptions)ParticleTypes.POOF, 1.0, 10);
                    HelperMethods.spawnOrbitParticles(world, livingEntity.position(), (ParticleOptions)ParticleTypes.EXPLOSION, 0.5, 2);
                    HelperMethods.spawnOrbitParticles(world, livingEntity.position(), (ParticleOptions)ParticleTypes.WARPED_SPORE, 1.0, 10);
                    livingEntity.igniteForSeconds(3.0f);
                    livingEntity.knockback(1.0, 0.1, 0.1);
                    livingEntity.invulnerableTime = 0;
                    livingEntity.hurt(damageSource, (float)HelperMethods.getEntityAttackDamage(attacker));
                    livingEntity.invulnerableTime = 0;
                }
                if (choose_sound <= 1) {
                    world.playSound(null, (Entity)target, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_01.get(), target.getSoundSource(), 0.5f, 1.2f);
                }
                if (choose_sound == 2) {
                    world.playSound(null, (Entity)target, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_02.get(), target.getSoundSource(), 0.7f, 1.1f);
                }
                if (choose_sound == 3) {
                    world.playSound(null, (Entity)target, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_03.get(), target.getSoundSource(), 0.9f, 1.0f);
                }
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.FALLING_LAVA, (ParticleOptions)ParticleTypes.FALLING_LAVA, (ParticleOptions)ParticleTypes.SMOKE, true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.firesworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.firesworditem.tooltip2").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0, max=100)
        public int chance;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.BRIMSTONE_CLAYMORE.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.chance = 15;
        }
    }
}

