/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.item.TwoHandedWeapon;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.item.component.StoredChargeComponent;
import net.sweenus.simplyswords.registry.ComponentTypeRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.AbilityMethods;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class HearthflameSwordItem
extends UniqueSwordItem
implements TwoHandedWeapon {
    int ability_timer_max = 120;

    public HearthflameSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            ServerLevel world = (ServerLevel)attacker.level();
            HelperMethods.playHitSounds(attacker, target);
            if (attacker.getRandom().nextInt(100) <= Config.uniqueEffects.hearthflame.chance) {
                target.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 10, 1), (Entity)attacker);
                target.setDeltaMovement(target.getX() - attacker.getX(), 0.5, target.getZ() - attacker.getZ());
                target.igniteForSeconds(5.0f);
                int choose_sound = (int)(Math.random() * 30.0);
                if (choose_sound <= 10) {
                    world.playSound(null, (Entity)target, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_01.get(), target.getSoundSource(), 0.5f, 1.2f);
                }
                if (choose_sound <= 20 && choose_sound > 10) {
                    world.playSound(null, (Entity)target, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_02.get(), target.getSoundSource(), 0.5f, 1.2f);
                }
                if (choose_sound <= 30 && choose_sound > 20) {
                    world.playSound(null, (Entity)target, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_03.get(), target.getSoundSource(), 0.5f, 1.2f);
                }
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        user.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20, 5), (Entity)user);
        user.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 20, 8), (Entity)user);
        user.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 20, 5), (Entity)user);
        ItemStack itemStack = user.getItemInHand(hand);
        if (itemStack.getDamageValue() >= itemStack.getMaxDamage() - 1) {
            return InteractionResultHolder.fail((Object)itemStack);
        }
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (HelperMethods.isHolding(stack, user) && user instanceof Player) {
            Player player = (Player)user;
            int radius = Config.uniqueEffects.hearthflame.radius;
            float spellScaling = HelperMethods.commonSpellAttributeScaling(Config.uniqueEffects.hearthflame.spellScaling, (Entity)user, "fire");
            float abilityDamage = spellScaling > 0.0f ? spellScaling : Config.uniqueEffects.hearthflame.damage;
            int chargePower = ((StoredChargeComponent)stack.getOrDefault((DataComponentType)ComponentTypeRegistry.STORED_CHARGE.get(), (Object)StoredChargeComponent.DEFAULT)).charge();
            AbilityMethods.tickAbilityVolcanicFury(stack, world, user, remainingUseTicks, this.ability_timer_max, abilityDamage, Config.uniqueEffects.hearthflame.cooldown, radius, chargePower);
            if (player.tickCount % 20 == 0) {
                stack.update((DataComponentType)ComponentTypeRegistry.STORED_CHARGE.get(), (Object)StoredChargeComponent.DEFAULT, comp -> comp.add(2));
            }
        }
    }

    @Override
    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return this.ability_timer_max;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (!world.isClientSide) {
            int choose_sound;
            if (user instanceof Player) {
                Player player = (Player)user;
                player.getCooldowns().addCooldown((Item)this, Config.uniqueEffects.hearthflame.chance);
            }
            if ((choose_sound = (int)(Math.random() * 30.0)) <= 10) {
                world.playSound(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_01.get(), user.getSoundSource(), 0.6f, 1.2f);
            } else if (choose_sound <= 20) {
                world.playSound(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_02.get(), user.getSoundSource(), 0.6f, 1.2f);
            } else if (choose_sound <= 30) {
                world.playSound(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_FIRE_SHOOT_IMPACT_03.get(), user.getSoundSource(), 0.6f, 1.2f);
            }
            int radius = Config.uniqueEffects.hearthflame.radius;
            AABB box = new AABB(user.getX() + (double)radius, user.getY() + (double)radius, user.getZ() + (double)radius, user.getX() - (double)radius, user.getY() - (double)radius, user.getZ() - (double)radius);
            for (Entity entity : world.getEntities((Entity)user, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)entity;
                if (!HelperMethods.checkFriendlyFire((LivingEntity)entity, user)) continue;
                float choose = (float)(Math.random() * 1.0);
                float spellScaling = HelperMethods.commonSpellAttributeScaling(Config.uniqueEffects.hearthflame.spellScaling, (Entity)user, "fire");
                float abilityDamage = spellScaling > 0.0f ? spellScaling : Config.uniqueEffects.hearthflame.damage;
                int chargePower = ((StoredChargeComponent)stack.getOrDefault((DataComponentType)ComponentTypeRegistry.STORED_CHARGE.get(), (Object)StoredChargeComponent.DEFAULT)).charge();
                le.hurt(user.damageSources().indirectMagic((Entity)user, (Entity)user), abilityDamage * ((float)chargePower * 0.3f));
                le.igniteForSeconds(6.0f);
                world.playSound(null, (Entity)le, (SoundEvent)SoundRegistry.ELEMENTAL_BOW_POISON_ATTACK_01.get(), le.getSoundSource(), 0.1f, choose);
                stack.set((DataComponentType)ComponentTypeRegistry.STORED_CHARGE.get(), (Object)StoredChargeComponent.DEFAULT);
                le.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 10, 1), (Entity)user);
                le.setDeltaMovement(le.getX() - user.getX(), 0.5, le.getZ() - user.getZ());
            }
        }
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.MYCELIUM, (ParticleOptions)ParticleTypes.MYCELIUM, (ParticleOptions)ParticleTypes.MYCELIUM, true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.volcanicfurysworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.volcanicfurysworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.volcanicfurysworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclickheld").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.volcanicfurysworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.volcanicfurysworditem.tooltip5").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.volcanicfurysworditem.tooltip6").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.volcanicfurysworditem.tooltip7").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.volcanicfurysworditem.tooltip8").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.volcanicfurysworditem.tooltip9").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
        TooltipUtils.appendSpellScaleTooltip(tooltip, "fire");
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0, max=100)
        public int chance;
        @ValidatedInt.Restrict(min=0)
        public int cooldown;
        @ValidatedFloat.Restrict(min=0.0f)
        public float damage;
        @ValidatedInt.Restrict(min=1)
        public int radius;
        @ValidatedFloat.Restrict(min=0.0f)
        public float spellScaling;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.HEARTHFLAME.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.chance = 25;
            this.cooldown = 300;
            this.damage = 3.0f;
            this.radius = 3;
            this.spellScaling = 1.4f;
        }
    }
}

