/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.entity.MagispearEntity;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class MagispearSwordItem
extends UniqueSwordItem {
    public MagispearSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            HelperMethods.playHitSounds(attacker, target);
            ServerLevel world = (ServerLevel)attacker.level();
            float hitChance = Config.uniqueEffects.magispear.magicChance;
            int random = new Random().nextInt(100);
            if ((float)random < hitChance) {
                float damage = Config.uniqueEffects.magispear.magicModifier;
                target.invulnerableTime = 0;
                target.hurt(attacker.damageSources().indirectMagic((Entity)attacker, (Entity)attacker), damage);
                target.invulnerableTime = 0;
                world.playSound(null, attacker.blockPosition(), (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.getSoundSource(), 0.2f, 1.1f);
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        int skillCooldown = Config.uniqueEffects.magispear.cooldown;
        world.playSound(null, user.blockPosition(), (SoundEvent)SoundRegistry.MAGIC_SHAMANIC_NORDIC_27.get(), user.getSoundSource(), 0.2f, 1.1f);
        user.addEffect(new MobEffectInstance(EffectRegistry.getReference(EffectRegistry.MAGISLAM), 62, 1));
        user.addEffect(new MobEffectInstance(EffectRegistry.getReference(EffectRegistry.RESILIENCE), 64, 3));
        ItemStack itemStack = user.getItemInHand(hand);
        if (!world.isClientSide) {
            itemStack = user.getItemInHand(hand);
            MagispearEntity magispearEntity = new MagispearEntity(world, (LivingEntity)user, itemStack.copy());
            magispearEntity.shootFromRotation((Entity)user, user.getXRot(), user.getYRot(), 0.0f, 1.5f, 1.0f);
            magispearEntity.setYRot(user.getYRot());
            magispearEntity.setXRot(user.getXRot() - 90.0f);
            double[] doubles = HelperMethods.getAttackFromSlot(user, itemStack, user.getUsedItemHand());
            magispearEntity.primaryBaseDamage = (float)doubles[0] * 0.5f;
            magispearEntity.hasLoyalty = 3;
            if (hand == InteractionHand.OFF_HAND) {
                magispearEntity.offhandThrow = true;
            }
            magispearEntity.setPosRaw(user.getX(), user.getEyeY() - 0.5, user.getZ());
            world.addFreshEntity((Entity)magispearEntity);
            if (!user.getAbilities().instabuild) {
                itemStack.shrink(1);
            }
        }
        user.swing(hand);
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)world.isClientSide());
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.ENCHANT, (ParticleOptions)ParticleTypes.ENCHANT, (ParticleOptions)ParticleTypes.ASH, true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.magispearsworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.magispearsworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.magispearsworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.magispearsworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclick").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.magispearsworditem.tooltip5").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.magispearsworditem.tooltip6").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.magispearsworditem.tooltip7").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.magispearsworditem.tooltip8").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.magispearsworditem.tooltip9").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0)
        public int cooldown;
        @ValidatedFloat.Restrict(min=0.0f)
        public float damageModifier;
        @ValidatedDouble.Restrict(min=1.0)
        public double radius;
        @ValidatedInt.Restrict(min=0, max=100)
        public int magicChance;
        @ValidatedFloat.Restrict(min=0.0f)
        public float magicModifier;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.MAGISPEAR.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.cooldown = 20;
            this.damageModifier = 2.0f;
            this.radius = 4.0;
            this.magicChance = 35;
            this.magicModifier = 2.0f;
        }
    }
}

