/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class ShadowstingSwordItem
extends UniqueSwordItem {
    public ShadowstingSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        HelperMethods.playHitSounds(attacker, target);
        if (!attacker.level().isClientSide() && attacker.getRandom().nextInt(100) <= Config.uniqueEffects.shadowsting.chance && attacker instanceof Player) {
            attacker.level().playSound(null, (Entity)attacker, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), attacker.getSoundSource(), 0.3f, 1.8f);
            float extraDamage = (float)target.getArmorValue() * Config.uniqueEffects.shadowsting.damageMulti / 2.0f;
            target.hurt(attacker.damageSources().indirectMagic((Entity)attacker, (Entity)attacker), extraDamage);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        world.playSound(null, (Entity)user, (SoundEvent)SoundRegistry.ELEMENTAL_SWORD_EARTH_ATTACK_01.get(), user.getSoundSource(), 0.4f, 1.6f);
        user.getCooldowns().addCooldown(this.getDefaultInstance().getItem(), Config.uniqueEffects.shadowsting.cooldown);
        int radius = Config.uniqueEffects.shadowsting.radius;
        AABB box = new AABB(user.getX() + (double)radius, user.getY() + (double)radius, user.getZ() + (double)radius, user.getX() - (double)radius, user.getY() - (double)radius, user.getZ() - (double)radius);
        for (Entity entity : world.getEntities((Entity)user, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
            LivingEntity le;
            if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, (LivingEntity)user)) continue;
            le.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, Config.uniqueEffects.shadowsting.blindDuration, 3), (Entity)user);
        }
        double xpos = user.getX() - (double)(radius + 1);
        double ypos = user.getY();
        double zpos = user.getZ() - (double)(radius + 1);
        for (int i = radius * 2; i > 0; --i) {
            for (int j = radius * 2; j > 0; --j) {
                float choose = (float)(Math.random() * 1.0);
                HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.LARGE_SMOKE, xpos + (double)i + (double)choose, ypos + 0.4, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
                HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, xpos + (double)i + (double)choose, ypos + 0.1, zpos + (double)j + (double)choose, 0.0, 0.0, 0.0);
                HelperMethods.spawnParticle(world, (ParticleOptions)ParticleTypes.SMOKE, xpos + (double)i + (double)choose, ypos, zpos + (double)j + (double)choose, 0.0, 0.1, 0.0);
            }
        }
        BlockState currentStateLow = world.getBlockState(user.blockPosition().relative(user.getMotionDirection(), 5));
        double targetPositionX = user.blockPosition().relative(user.getMotionDirection(), 5).getX();
        double targetPositionY = user.blockPosition().relative(user.getMotionDirection(), 5).getY();
        double targetPositionZ = user.blockPosition().relative(user.getMotionDirection(), 5).getZ();
        BlockState currentStateHigh = world.getBlockState(user.blockPosition().above(1).relative(user.getMotionDirection(), 5));
        BlockState state = Blocks.AIR.defaultBlockState();
        if (currentStateLow == state && currentStateHigh == state) {
            user.randomTeleport(targetPositionX, targetPositionY, targetPositionZ, false);
        }
        return super.use(world, user, hand);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.MYCELIUM, (ParticleOptions)ParticleTypes.MYCELIUM, (ParticleOptions)ParticleTypes.MYCELIUM, true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.shadowmistsworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.shadowmistsworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.shadowmistsworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclick").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.shadowmistsworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.shadowmistsworditem.tooltip5").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0, max=100)
        public int chance;
        @ValidatedInt.Restrict(min=0)
        public int cooldown;
        @ValidatedFloat.Restrict(min=0.0f)
        public float damageMulti;
        @ValidatedInt.Restrict(min=1)
        public int radius;
        @ValidatedInt.Restrict(min=0)
        public int blindDuration;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.SHADOWSTING.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.chance = 25;
            this.cooldown = 200;
            this.damageMulti = 0.8f;
            this.radius = 4;
            this.blindDuration = 60;
        }
    }
}

