/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.item.custom;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedFloat;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.ItemStackTooltipAppender;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.item.TwoHandedWeapon;
import net.sweenus.simplyswords.item.UniqueSwordItem;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class SoulrenderSwordItem
extends UniqueSwordItem
implements TwoHandedWeapon {
    public SoulrenderSwordItem(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, settings);
    }

    @Override
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.level().isClientSide()) {
            ServerLevel world = (ServerLevel)attacker.level();
            int hitChance = Config.uniqueEffects.soulrender.chance;
            int duration = Config.uniqueEffects.soulrender.duration;
            int maxStacks = Config.uniqueEffects.soulrender.maxStacks;
            SimpleParticleType particleSelect = ParticleTypes.ASH;
            int particleCount = 8;
            if (attacker.getRandom().nextInt(100) <= hitChance) {
                int a;
                particleSelect = ParticleTypes.SMOKE;
                HelperMethods.spawnOrbitParticles(world, target.position(), (ParticleOptions)particleSelect, 0.5, particleCount);
                HelperMethods.spawnOrbitParticles(world, target.position().add(0.0, 0.2, 0.0), (ParticleOptions)ParticleTypes.SOUL, 0.4f, 5);
                int choose_sound = (int)(Math.random() * 30.0);
                if (choose_sound <= 10) {
                    world.playSound(null, (Entity)target, (SoundEvent)SoundRegistry.DARK_SWORD_ATTACK_WITH_BLOOD_01.get(), target.getSoundSource(), 0.4f, 1.5f);
                } else if (choose_sound <= 20) {
                    world.playSound(null, (Entity)target, (SoundEvent)SoundRegistry.DARK_SWORD_ATTACK_WITH_BLOOD_02.get(), target.getSoundSource(), 0.4f, 1.5f);
                } else if (choose_sound <= 30) {
                    world.playSound(null, (Entity)target, (SoundEvent)SoundRegistry.DARK_SWORD_ATTACK_WITH_BLOOD_03.get(), target.getSoundSource(), 0.4f, 1.5f);
                }
                if (target.hasEffect(MobEffects.WEAKNESS)) {
                    a = target.getEffect(MobEffects.WEAKNESS).getAmplifier() + 1;
                    if (target.getEffect(MobEffects.WEAKNESS).getAmplifier() <= 0) {
                        target.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, duration, a), (Entity)attacker);
                    }
                } else {
                    target.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, duration, 0), (Entity)attacker);
                }
                if (target.hasEffect(MobEffects.MOVEMENT_SLOWDOWN)) {
                    a = target.getEffect(MobEffects.MOVEMENT_SLOWDOWN).getAmplifier() + 1;
                    if (target.getEffect(MobEffects.MOVEMENT_SLOWDOWN).getAmplifier() < maxStacks) {
                        target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, duration, a), (Entity)attacker);
                    }
                } else {
                    target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, duration, 0), (Entity)attacker);
                }
            }
            HelperMethods.spawnWaistHeightParticles(world, (ParticleOptions)particleSelect, (Entity)attacker, (Entity)target, particleCount);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (!user.level().isClientSide()) {
            float heal_amount = Config.uniqueEffects.soulrender.healMulti;
            int healamp = 0;
            double hradius = Config.uniqueEffects.soulrender.radius;
            double vradius = Config.uniqueEffects.soulrender.radius / 2.0;
            double x = user.getX();
            double y = user.getY();
            double z = user.getZ();
            ServerLevel sworld = (ServerLevel)user.level();
            AABB box = new AABB(x + hradius, y + vradius, z + hradius, x - hradius, y - vradius, z - hradius);
            for (Entity entity : sworld.getEntities((Entity)user, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                LivingEntity le;
                if (!(entity instanceof LivingEntity) || !(le = (LivingEntity)entity).hasEffect(MobEffects.MOVEMENT_SLOWDOWN) || !le.hasEffect(MobEffects.WEAKNESS) || !HelperMethods.checkFriendlyFire(le, (LivingEntity)user)) continue;
                healamp += le.getEffect(MobEffects.MOVEMENT_SLOWDOWN).getAmplifier();
                float scaling = HelperMethods.commonSpellAttributeScaling(Config.uniqueEffects.soulrender.spellScaling, entity, "soul");
                float multiplier = scaling > 0.0f ? scaling : Config.uniqueEffects.soulrender.damageMulti;
                le.hurt(user.damageSources().indirectMagic((Entity)user, (Entity)user), (float)le.getEffect(MobEffects.MOVEMENT_SLOWDOWN).getAmplifier() * multiplier);
                le.removeEffect(MobEffects.WEAKNESS);
                le.removeEffect(MobEffects.MOVEMENT_SLOWDOWN);
                world.playSound(null, entity, (SoundEvent)SoundRegistry.DARK_SWORD_SPELL.get(), entity.getSoundSource(), 0.1f, 2.0f);
            }
            if (healamp > 0) {
                float heal = (float)healamp * heal_amount;
                if (heal < 1.0f) {
                    heal = 1.0f;
                } else if (heal > 6.0f) {
                    heal = 6.0f;
                }
                user.heal(heal);
            }
        }
        return super.use(world, user, hand);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        HelperMethods.createFootfalls(entity, stack, world, (ParticleOptions)ParticleTypes.SOUL, (ParticleOptions)ParticleTypes.SCULK_SOUL, (ParticleOptions)ParticleTypes.WARPED_SPORE, true);
        super.inventoryTick(stack, world, entity, slot, selected);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.rendsworditem.tooltip1").setStyle(Styles.ABILITY));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.rendsworditem.tooltip2").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.rendsworditem.tooltip3").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.literal((String)""));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclick").setStyle(Styles.RIGHT_CLICK));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.rendsworditem.tooltip4").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.rendsworditem.tooltip5").setStyle(Styles.TEXT));
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.rendsworditem.tooltip6").setStyle(Styles.TEXT));
        super.appendHoverText(itemStack, tooltipContext, tooltip, type);
        TooltipUtils.appendSpellScaleTooltip(tooltip, "soul");
    }

    public static class EffectSettings
    extends TooltipSettings {
        @ValidatedInt.Restrict(min=0, max=100)
        public int chance;
        @ValidatedInt.Restrict(min=0)
        public int duration;
        @ValidatedInt.Restrict(min=1)
        public int maxStacks;
        @ValidatedDouble.Restrict(min=1.0)
        public double radius;
        @ValidatedFloat.Restrict(min=0.0f)
        public float healMulti;
        @ValidatedFloat.Restrict(min=0.0f)
        public float damageMulti;
        @ValidatedFloat.Restrict(min=0.0f)
        public float spellScaling;

        public EffectSettings() {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ItemsRegistry.SOULRENDER.get();
            super(new ItemStackTooltipAppender(supplierArray));
            this.chance = 85;
            this.duration = 500;
            this.maxStacks = 8;
            this.radius = 10.0;
            this.healMulti = 0.5f;
            this.damageMulti = 3.0f;
            this.spellScaling = 0.4f;
        }
    }
}

