/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.mixin;

import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.sweenus.simplyswords.registry.ItemsRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin {
    @Shadow
    @Final
    private Abilities abilities;

    @Shadow
    protected abstract void removeEntitiesOnShoulder();

    @Unique
    public void simplySwords$invokeDropShoulderEntities() {
        this.removeEntitiesOnShoulder();
    }

    @Inject(at={@At(value="HEAD")}, method={"removeEntitiesOnShoulder()V"}, cancellable=true)
    public void simplyswords$dropShoulderEntities(CallbackInfo ci) {
        Player player = (Player)this;
        if (!HelperMethods.hasItemInInventory(player, (Item)ItemsRegistry.CHOMPOLOTL.get())) {
            return;
        }
        if (!(player.isInWater() || player.isShiftKeyDown() || player.isSleeping() || player.isInPowderSnow || this.abilities.flying || !player.isAlive())) {
            if (player.getShoulderEntityLeft() != null && "simplyswords:simplyaxolotlentity".equals(player.getShoulderEntityLeft().getString("id"))) {
                ci.cancel();
            }
            if (player.getShoulderEntityRight() != null && "simplyswords:simplyaxolotlentity".equals(player.getShoulderEntityRight().getString("id"))) {
                ci.cancel();
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tick()V"})
    public void simplyswords$tick(CallbackInfo ci) {
        Player player = (Player)this;
        if (player.tickCount % 40 == 0 && !HelperMethods.hasItemInInventory(player, (Item)ItemsRegistry.CHOMPOLOTL.get())) {
            this.removeEntitiesOnShoulder();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"aiStep()V"})
    public void simplyswords$tickMovement(CallbackInfo ci) {
        Player player = (Player)this;
        if (!player.level().isClientSide() && (player.isInWater() || player.isShiftKeyDown())) {
            this.removeEntitiesOnShoulder();
        }
    }
}

