/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.power.powers;

import java.util.List;
import java.util.function.Supplier;
import me.fzzyhmstrs.fzzy_config.annotations.Translation;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedDouble;
import me.fzzyhmstrs.fzzy_config.validation.number.ValidatedInt;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.config.Config;
import net.sweenus.simplyswords.config.settings.TooltipSettings;
import net.sweenus.simplyswords.power.RunefusedGemPower;
import net.sweenus.simplyswords.registry.GemPowerRegistry;
import net.sweenus.simplyswords.util.HelperMethods;
import net.sweenus.simplyswords.util.Styles;

public class ActiveDefencePower
extends RunefusedGemPower {
    public ActiveDefencePower() {
        super(false);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level world, LivingEntity user, int slot, boolean selected) {
        int frequency;
        Player player;
        if (user instanceof Player && (player = (Player)user).getInventory().contains(Items.ARROW.getDefaultInstance()) && player.tickCount % (frequency = Config.gemPowers.activeDefence.frequency) == 0) {
            double sradius = Config.gemPowers.activeDefence.radius;
            double vradius = Config.gemPowers.activeDefence.radius / 2.0;
            double x = player.getX();
            double y = player.getY();
            double z = player.getZ();
            AABB box = new AABB(x + sradius, y + vradius, z + sradius, x - sradius, y - vradius, z - sradius);
            for (Entity entity : world.getEntities((Entity)player, box, EntitySelector.LIVING_ENTITY_STILL_ALIVE)) {
                LivingEntity le;
                if (!(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entity, (LivingEntity)player)) continue;
                int arrowSlot = player.getInventory().findSlotMatchingItem(Items.ARROW.getDefaultInstance());
                ItemStack arrowStack = player.getInventory().getItem(arrowSlot);
                int randomc = (int)(Math.random() * 100.0);
                if (randomc < 15) {
                    arrowStack.shrink(1);
                }
                Arrow arrow = new Arrow(EntityType.ARROW, world);
                arrow.absMoveTo(player.getX(), player.getY() + 1.5, player.getZ());
                arrow.setOwner((Entity)player);
                arrow.setDeltaMovement(le.getX() - player.getX(), le.getY() - player.getY() - 1.0, le.getZ() - player.getZ());
                world.addFreshEntity((Entity)arrow);
                break;
            }
        }
    }

    @Override
    public void appendTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type, boolean isRunic) {
        if (isRunic) {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.activedefencesworditem.tooltip1").setStyle(Styles.RUNIC));
        } else {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.uniquesworditem.runefused_power.active_defence").setStyle(Styles.RUNIC));
        }
        if (TooltipUtils.shouldDisplayTooltip(itemStack, null)) {
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.activedefencesworditem.tooltip2")).setStyle(Styles.RUNIC_DESCRIPTION));
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.activedefencesworditem.tooltip3")).setStyle(Styles.RUNIC_DESCRIPTION));
        }
    }

    public static class Settings
    extends TooltipSettings {
        @Translation(prefix="simplyswords.config.basic_settings")
        @ValidatedInt.Restrict(min=1)
        public int frequency = 20;
        @Translation(prefix="simplyswords.config.basic_settings")
        @ValidatedDouble.Restrict(min=0.0)
        public double radius = 5.0;

        public Settings() {
            super((Supplier<? extends TooltipProvider>)GemPowerRegistry.ACTIVE_DEFENCE);
        }
    }
}

