/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyswords.power.powers;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.sweenus.simplyswords.client.util.TooltipUtils;
import net.sweenus.simplyswords.power.RunicGemPower;
import net.sweenus.simplyswords.registry.EffectRegistry;
import net.sweenus.simplyswords.registry.SoundRegistry;
import net.sweenus.simplyswords.util.Styles;

public class ImmolationPower
extends RunicGemPower {
    public ImmolationPower() {
        super(false);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand, ItemStack itemStack) {
        user.startUsingItem(hand);
        user.addEffect(new MobEffectInstance(EffectRegistry.getReference(EffectRegistry.IMMOLATION), 800, 3), (Entity)user);
        user.getCooldowns().addCooldown(itemStack.getItem(), 40);
        world.playSound(null, (Entity)user, (SoundEvent)SoundRegistry.MAGIC_SWORD_SPELL_02.get(), user.getSoundSource(), 0.3f, 0.6f);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    @Override
    public int getMaxUseTime(ItemStack stack) {
        return 1;
    }

    @Override
    public void appendTooltip(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag type, boolean isRunic) {
        tooltip.add((Component)Component.translatable((String)"item.simplyswords.immolationsworditem.tooltip1").setStyle(Styles.RUNIC));
        if (TooltipUtils.shouldDisplayTooltip(itemStack, null)) {
            tooltip.add((Component)Component.translatable((String)"item.simplyswords.onrightclick").setStyle(Styles.RIGHT_CLICK));
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.immolationsworditem.tooltip2")).setStyle(Styles.RUNIC_DESCRIPTION));
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.immolationsworditem.tooltip3")).setStyle(Styles.RUNIC_DESCRIPTION));
            tooltip.add((Component)Component.literal((String)"\u00a0\u00a0\u00a0").append((Component)Component.translatable((String)"item.simplyswords.immolationsworditem.tooltip4")).setStyle(Styles.RUNIC_DESCRIPTION));
        }
    }
}

