/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.api.datagen.builders.page_components.components;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import java.util.Arrays;
import java.util.List;
import net.favouriteless.modopedia.api.datagen.builders.PageComponentBuilder;
import net.favouriteless.modopedia.client.page_components.ImagePageComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;

public class ImageBuilder
extends PageComponentBuilder {
    private final Either<List<ResourceLocation>, String> images;
    private Either<Integer, String> width;
    private Either<Integer, String> height;

    private ImageBuilder(String images) {
        super(ImagePageComponent.ID);
        this.images = Either.right((Object)images);
    }

    private ImageBuilder(ResourceLocation ... images) {
        super(ImagePageComponent.ID);
        this.images = Either.left(Arrays.asList(images));
    }

    public static ImageBuilder of(ResourceLocation ... images) {
        return new ImageBuilder(images);
    }

    public static ImageBuilder of(String images) {
        return new ImageBuilder(images);
    }

    @Override
    public ImageBuilder x(int x) {
        return (ImageBuilder)super.x(x);
    }

    @Override
    public ImageBuilder x(String x) {
        return (ImageBuilder)super.x(x);
    }

    @Override
    public ImageBuilder y(int y) {
        return (ImageBuilder)super.y(y);
    }

    @Override
    public ImageBuilder y(String y) {
        return (ImageBuilder)super.y(y);
    }

    public ImageBuilder width(int width) {
        this.width = Either.left((Object)width);
        return this;
    }

    public ImageBuilder width(String width) {
        this.width = Either.right((Object)width);
        return this;
    }

    public ImageBuilder height(int height) {
        this.height = Either.left((Object)height);
        return this;
    }

    public ImageBuilder height(String height) {
        this.height = Either.right((Object)height);
        return this;
    }

    @Override
    protected void build(JsonObject json, RegistryOps<JsonElement> ops) {
        json.add("images", this.resolve(this.images, l -> (JsonElement)ResourceLocation.CODEC.listOf().encodeStart((DynamicOps)ops, l).getOrThrow()));
        if (this.width != null) {
            json.add("width", this.resolveNum(this.width));
        }
        if (this.height != null) {
            json.add("height", this.resolveNum(this.height));
        }
    }
}

