/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.api.datagen.builders.templates;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.datagen.builders.page_components.TemplateComponentBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class LargeFramedEntityBuilder
extends TemplateComponentBuilder {
    public static final ResourceLocation ID = Modopedia.id("large_framed_entity");
    private final Either<EntityType<?>, String> entity;
    private Either<CompoundTag, String> tag;
    private Either<Float, String> offsetY;
    private Either<Float, String> scale;
    private Either<Integer, String> width;

    private LargeFramedEntityBuilder(EntityType<?> type) {
        super(ID);
        this.entity = Either.left(type);
    }

    private LargeFramedEntityBuilder(String type) {
        super(ID);
        this.entity = Either.right((Object)type);
    }

    public static LargeFramedEntityBuilder of(EntityType<?> type) {
        return new LargeFramedEntityBuilder(type);
    }

    public static LargeFramedEntityBuilder of(String type) {
        return new LargeFramedEntityBuilder(type);
    }

    @Override
    public LargeFramedEntityBuilder x(int x) {
        return (LargeFramedEntityBuilder)super.x(x);
    }

    @Override
    public LargeFramedEntityBuilder x(String x) {
        return (LargeFramedEntityBuilder)super.x(x);
    }

    @Override
    public LargeFramedEntityBuilder y(int y) {
        return (LargeFramedEntityBuilder)super.y(y);
    }

    @Override
    public LargeFramedEntityBuilder y(String y) {
        return (LargeFramedEntityBuilder)super.y(y);
    }

    public LargeFramedEntityBuilder tag(CompoundTag tag) {
        this.tag = Either.left((Object)tag);
        return this;
    }

    public LargeFramedEntityBuilder tag(String tag) {
        this.tag = Either.right((Object)tag);
        return this;
    }

    public LargeFramedEntityBuilder width(int width) {
        this.width = Either.left((Object)width);
        return this;
    }

    public LargeFramedEntityBuilder width(String width) {
        this.width = Either.right((Object)width);
        return this;
    }

    public LargeFramedEntityBuilder scale(float scale) {
        this.scale = Either.left((Object)Float.valueOf(scale));
        return this;
    }

    public LargeFramedEntityBuilder scale(String reference) {
        this.scale = Either.right((Object)reference);
        return this;
    }

    public LargeFramedEntityBuilder offsetY(float offsetY) {
        this.offsetY = Either.left((Object)Float.valueOf(offsetY));
        return this;
    }

    public LargeFramedEntityBuilder offsetY(String reference) {
        this.offsetY = Either.right((Object)reference);
        return this;
    }

    @Override
    protected void build(JsonObject json, RegistryOps<JsonElement> ops) {
        json.add("entity", this.resolve(this.entity, e -> (JsonElement)ResourceLocation.CODEC.encodeStart((DynamicOps)ops, (Object)BuiltInRegistries.ENTITY_TYPE.getKey(e)).getOrThrow()));
        if (this.tag != null) {
            json.add("tag", this.resolve(this.tag, t -> (JsonElement)CompoundTag.CODEC.encodeStart((DynamicOps)ops, t).getOrThrow()));
        }
        if (this.offsetY != null) {
            json.add("offset_y", this.resolveNum(this.offsetY));
        }
        if (this.scale != null) {
            json.add("scale", this.resolveNum(this.scale));
        }
        if (this.width != null) {
            json.add("width", this.resolveNum(this.width));
        }
    }
}

