/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.api.datagen.builders.templates;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.datagen.builders.page_components.TemplateComponentBuilder;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class MediumFramedShowcaseBuilder
extends TemplateComponentBuilder {
    public static final ResourceLocation ID = Modopedia.id("medium_framed_showcase");
    private final Either<List<ItemStack>, String> items;
    private Either<Integer, String> width;
    private Either<Float, String> scale;

    private MediumFramedShowcaseBuilder(ItemStack ... items) {
        super(ID);
        this.items = Either.left(List.of(items));
    }

    private MediumFramedShowcaseBuilder(String items) {
        super(ID);
        this.items = Either.right((Object)items);
    }

    public static MediumFramedShowcaseBuilder of(ItemStack ... items) {
        return new MediumFramedShowcaseBuilder(items);
    }

    public static MediumFramedShowcaseBuilder of(String type) {
        return new MediumFramedShowcaseBuilder(type);
    }

    @Override
    public MediumFramedShowcaseBuilder x(int x) {
        return (MediumFramedShowcaseBuilder)super.x(x);
    }

    @Override
    public MediumFramedShowcaseBuilder x(String x) {
        return (MediumFramedShowcaseBuilder)super.x(x);
    }

    @Override
    public MediumFramedShowcaseBuilder y(int y) {
        return (MediumFramedShowcaseBuilder)super.y(y);
    }

    @Override
    public MediumFramedShowcaseBuilder y(String y) {
        return (MediumFramedShowcaseBuilder)super.y(y);
    }

    public MediumFramedShowcaseBuilder width(int width) {
        this.width = Either.left((Object)width);
        return this;
    }

    public MediumFramedShowcaseBuilder width(String width) {
        this.width = Either.right((Object)width);
        return this;
    }

    public MediumFramedShowcaseBuilder scale(float scale) {
        this.scale = Either.left((Object)Float.valueOf(scale));
        return this;
    }

    public MediumFramedShowcaseBuilder scale(String scale) {
        this.scale = Either.right((Object)scale);
        return this;
    }

    @Override
    protected void build(JsonObject json, RegistryOps<JsonElement> ops) {
        json.add("items", this.resolve(this.items, l -> (JsonElement)ItemStack.CODEC.listOf().encodeStart((DynamicOps)ops, l).getOrThrow()));
        if (this.width != null) {
            json.add("width", this.resolveNum(this.width));
        }
        if (this.scale != null) {
            json.add("scale", this.resolveNum(this.scale));
        }
    }
}

