/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.api.datagen.builders.templates.page;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.datagen.builders.page_components.TemplateComponentBuilder;
import net.favouriteless.modopedia.client.multiblock.BlockStateCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;

public class BlockPageBuilder
extends TemplateComponentBuilder {
    public static final ResourceLocation ID = Modopedia.id("page/block");
    private final String text;
    private final Either<BlockState, String> block;
    private Either<Integer, String> height;
    private Either<Integer, String> textOffset;
    private Either<Float, String> offsetX;
    private Either<Float, String> offsetY;
    private Either<Float, String> scale;
    private Either<Float, String> viewAngle;

    protected BlockPageBuilder(String text, BlockState block) {
        super(ID);
        this.text = text;
        this.block = Either.left((Object)block);
    }

    protected BlockPageBuilder(String text, String block) {
        super(ID);
        this.text = text;
        this.block = Either.right((Object)block);
    }

    public static BlockPageBuilder of(String text, BlockState block) {
        return new BlockPageBuilder(text, block);
    }

    public static BlockPageBuilder of(String text, String block) {
        return new BlockPageBuilder(text, block);
    }

    @Override
    public BlockPageBuilder x(int x) {
        return (BlockPageBuilder)super.x(x);
    }

    @Override
    public BlockPageBuilder x(String x) {
        return (BlockPageBuilder)super.x(x);
    }

    @Override
    public BlockPageBuilder y(int y) {
        return (BlockPageBuilder)super.y(y);
    }

    @Override
    public BlockPageBuilder y(String y) {
        return (BlockPageBuilder)super.y(y);
    }

    public BlockPageBuilder height(int height) {
        this.height = Either.left((Object)height);
        return this;
    }

    public BlockPageBuilder height(String height) {
        this.height = Either.right((Object)height);
        return this;
    }

    public BlockPageBuilder scale(float scale) {
        this.scale = Either.left((Object)Float.valueOf(scale));
        return this;
    }

    public BlockPageBuilder scale(String scale) {
        this.scale = Either.right((Object)scale);
        return this;
    }

    public BlockPageBuilder offsetX(float offsetX) {
        this.offsetX = Either.left((Object)Float.valueOf(offsetX));
        return this;
    }

    public BlockPageBuilder offsetX(String offsetX) {
        this.offsetX = Either.right((Object)offsetX);
        return this;
    }

    public BlockPageBuilder offsetY(float offsetY) {
        this.offsetY = Either.left((Object)Float.valueOf(offsetY));
        return this;
    }

    public BlockPageBuilder offsetY(String offsetY) {
        this.offsetY = Either.right((Object)offsetY);
        return this;
    }

    public BlockPageBuilder viewAngle(float viewAngle) {
        this.viewAngle = Either.left((Object)Float.valueOf(viewAngle));
        return this;
    }

    public BlockPageBuilder viewAngle(String viewAngle) {
        this.viewAngle = Either.right((Object)viewAngle);
        return this;
    }

    public BlockPageBuilder textOffset(int textOffset) {
        this.textOffset = Either.left((Object)textOffset);
        return this;
    }

    public BlockPageBuilder textOffset(String textOffset) {
        this.textOffset = Either.right((Object)textOffset);
        return this;
    }

    @Override
    protected void build(JsonObject json, RegistryOps<JsonElement> ops) {
        json.add("text", this.resolveString(this.text));
        if (this.block != null) {
            json.add("block", this.resolve(this.block, b -> (JsonElement)BlockStateCodec.CODEC.encodeStart((DynamicOps)ops, b).getOrThrow()));
        }
        if (this.textOffset != null) {
            json.add("text_offset", this.resolveNum(this.textOffset));
        }
        if (this.height != null) {
            json.add("height", this.resolveNum(this.height));
        }
        if (this.offsetX != null) {
            json.add("offset_x", this.resolveNum(this.offsetX));
        }
        if (this.offsetY != null) {
            json.add("offset_y", this.resolveNum(this.offsetY));
        }
        if (this.scale != null) {
            json.add("scale", this.resolveNum(this.scale));
        }
        if (this.viewAngle != null) {
            json.add("view_angle", this.resolveNum(this.viewAngle));
        }
    }
}

