/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.api.datagen.builders.templates.page;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.datagen.builders.page_components.TemplateComponentBuilder;
import net.favouriteless.modopedia.book.text.Justify;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;

public class HeaderedTextBuilder
extends TemplateComponentBuilder {
    public static final ResourceLocation ID = Modopedia.id("page/headered_text");
    private final String header;
    private final String text;
    private Either<Integer, String> width;
    private Either<Integer, String> lineHeight;
    private Either<Justify, String> justify;
    private Either<Boolean, String> centered;
    private Either<Boolean, String> bold;
    private Either<Boolean, String> underline;
    private Either<Integer, String> colour;

    protected HeaderedTextBuilder(String header, String text) {
        super(ID);
        this.header = header;
        this.text = text;
    }

    public static HeaderedTextBuilder of(String header, String text) {
        return new HeaderedTextBuilder(header, text);
    }

    @Override
    public HeaderedTextBuilder x(int x) {
        return (HeaderedTextBuilder)super.x(x);
    }

    @Override
    public HeaderedTextBuilder x(String x) {
        return (HeaderedTextBuilder)super.x(x);
    }

    @Override
    public HeaderedTextBuilder y(int y) {
        return (HeaderedTextBuilder)super.y(y);
    }

    @Override
    public HeaderedTextBuilder y(String y) {
        return (HeaderedTextBuilder)super.y(y);
    }

    public HeaderedTextBuilder width(int width) {
        this.width = Either.left((Object)width);
        return this;
    }

    public HeaderedTextBuilder width(String width) {
        this.width = Either.right((Object)width);
        return this;
    }

    public HeaderedTextBuilder lineHeight(int height) {
        this.lineHeight = Either.left((Object)height);
        return this;
    }

    public HeaderedTextBuilder lineHeight(String height) {
        this.lineHeight = Either.right((Object)height);
        return this;
    }

    public HeaderedTextBuilder justify(Justify justify) {
        this.justify = Either.left((Object)((Object)justify));
        return this;
    }

    public HeaderedTextBuilder justify(String justify) {
        this.justify = Either.right((Object)justify);
        return this;
    }

    public HeaderedTextBuilder centered(boolean centered) {
        this.centered = Either.left((Object)centered);
        return this;
    }

    public HeaderedTextBuilder centered(String centered) {
        this.centered = Either.right((Object)centered);
        return this;
    }

    public HeaderedTextBuilder colour(int colour) {
        this.colour = Either.left((Object)colour);
        return this;
    }

    public HeaderedTextBuilder colour(String colour) {
        this.colour = Either.right((Object)colour);
        return this;
    }

    public HeaderedTextBuilder bold(boolean centered) {
        this.bold = Either.left((Object)centered);
        return this;
    }

    public HeaderedTextBuilder bold(String reference) {
        this.bold = Either.right((Object)reference);
        return this;
    }

    public HeaderedTextBuilder underline(boolean underline) {
        this.underline = Either.left((Object)underline);
        return this;
    }

    public HeaderedTextBuilder underline(String underline) {
        this.underline = Either.right((Object)underline);
        return this;
    }

    @Override
    protected void build(JsonObject json, RegistryOps<JsonElement> ops) {
        json.add("header", this.resolveString(this.header));
        json.add("text", this.resolveString(this.text));
        if (this.width != null) {
            json.add("width", this.resolveNum(this.width));
        }
        if (this.lineHeight != null) {
            json.add("line_height", this.resolveNum(this.lineHeight));
        }
        if (this.justify != null) {
            json.add("justify", this.resolve(this.justify, j -> (JsonElement)Justify.CODEC.encodeStart((DynamicOps)ops, (Object)j).getOrThrow()));
        }
        if (this.centered != null) {
            json.add("centered", this.resolveBool(this.centered));
        }
        if (this.bold != null) {
            json.add("bold", this.resolveBool(this.bold));
        }
        if (this.underline != null) {
            json.add("underline", this.resolveBool(this.underline));
        }
        if (this.colour != null) {
            json.add("colour", this.resolveNum(this.colour));
        }
    }
}

