/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.book;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.book.registries.client.ItemAssociationRegistry;
import net.favouriteless.modopedia.client.BookOpenHandler;
import net.favouriteless.modopedia.client.init.MKeyMappings;
import net.favouriteless.modopedia.client.screens.books.BookScreen;
import net.favouriteless.modopedia.common.ServerConfig;
import net.favouriteless.modopedia.util.common.InventoryUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class StudyManager {
    public static final int STUDY_TICKS_MAX = 20;
    private static int studyTicks = 0;

    public static void study(Item item) {
        String lang = Minecraft.getInstance().options.languageCode;
        ItemAssociationRegistry.EntryAssociation association = StudyManager.getAssociation(lang, item);
        if (association != null && InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)MKeyMappings.KEY_STUDY.key.getValue())) {
            if (++studyTicks < 20) {
                return;
            }
            StudyManager.stopStudying();
            BookOpenHandler.tryOpenEntry(association.book(), association.entryId());
        } else {
            studyTicks = Math.max(studyTicks - 1, 0);
        }
    }

    public static int getStudyTicks() {
        return studyTicks;
    }

    public static void stopStudying() {
        studyTicks = 0;
    }

    public static List<Component> getTooltips(Item item) {
        Minecraft mc = Minecraft.getInstance();
        if (!(mc.screen instanceof AbstractContainerScreen) && !(mc.screen instanceof BookScreen)) {
            return List.of();
        }
        ItemAssociationRegistry.EntryAssociation association = StudyManager.getAssociation(mc.options.languageCode, item);
        if (association == null) {
            return List.of();
        }
        ArrayList<Component> out = new ArrayList<Component>();
        MutableComponent study = Component.translatable((String)Modopedia.translation("tooltip", "study"), (Object[])new Object[]{MKeyMappings.KEY_STUDY.getTranslatedKeyMessage().getString()}).withStyle(ChatFormatting.DARK_GRAY);
        out.add((Component)study);
        int width = mc.font.width((FormattedText)study);
        int studyBars = width / mc.font.width("|");
        int g = Math.round((float)studyTicks / 20.0f * (float)studyBars);
        int r = studyBars - g;
        if (g > 0) {
            MutableComponent bars = Component.literal((String)"|".repeat(g)).withStyle(ChatFormatting.GREEN);
            if (r > 0) {
                bars.append((Component)Component.literal((String)"|".repeat(r)).withStyle(ChatFormatting.RED));
            }
            out.add((Component)bars);
        }
        return out;
    }

    public static ItemAssociationRegistry.EntryAssociation getAssociation(String lang, Item item) {
        Minecraft mc = Minecraft.getInstance();
        ItemAssociationRegistry.EntryAssociation association = ItemAssociationRegistry.getAssociation(mc.options.languageCode, item);
        if (association == null || ((Boolean)ServerConfig.INSTANCE.studyRequiresBooks.get()).booleanValue() && !InventoryUtils.hasBook((Player)mc.player, association.book())) {
            return null;
        }
        return association;
    }
}

