/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.book.text;

import net.favouriteless.modopedia.api.book.page_components.BookRenderContext;
import net.favouriteless.modopedia.api.book.page_components.PageEventListener;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class TextChunk
implements PageEventListener {
    protected final Component text;
    protected int x;
    protected int y;
    protected final int width;
    protected final int height;

    public TextChunk(Component text, int x, int y, int width, int height) {
        this.text = text;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void render(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        Font font = Minecraft.getInstance().font;
        graphics.drawString(font, this.text, this.x + x, this.y + y, 0, false);
        if (this.isMouseOver(mouseX, mouseY)) {
            graphics.renderComponentHoverEffect(font, this.text.getStyle(), mouseX + x, mouseY + y);
        }
    }

    @Override
    public boolean mouseClicked(BookRenderContext context, double mouseX, double mouseY, int button) {
        if (button == 0 && this.isMouseOver(mouseX, mouseY) && this.text.getStyle().getClickEvent() != null) {
            context.getScreen().handleComponentClicked(this.text.getStyle());
            return true;
        }
        return false;
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX > (double)this.x && mouseX < (double)(this.x + this.width) && mouseY > (double)this.y && mouseY < (double)(this.y + this.height);
    }
}

