/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.page_components;

import com.mojang.blaze3d.vertex.PoseStack;
import net.favouriteless.modopedia.api.Lookup;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.BookTexture;
import net.favouriteless.modopedia.api.book.page_components.BookRenderContext;
import net.favouriteless.modopedia.api.book.page_components.PageComponent;
import net.favouriteless.modopedia.api.book.page_components.PageWidgetHolder;
import net.favouriteless.modopedia.api.registries.client.BookTextureRegistry;
import net.favouriteless.modopedia.book.PageComponentHolder;
import net.favouriteless.modopedia.client.page_widgets.PageImageButton;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class GalleryPageComponent
extends PageComponent {
    private final PageComponentHolder holder;
    private PageImageButton leftButton;
    private PageImageButton rightButton;
    private int selectedComponent = 0;
    private int width;
    private int height;

    public GalleryPageComponent(PageComponentHolder holder) {
        this.holder = holder;
    }

    @Override
    public void init(Book book, Lookup lookup, Level level) {
        super.init(book, lookup, level);
        if (this.holder.getComponents().isEmpty()) {
            throw new IllegalArgumentException("Gallery cannot have zero components");
        }
        this.holder.initComponents(book, lookup.get("entry").asString(), level);
        BookTexture tex = BookTextureRegistry.get().getTexture(book.getTexture());
        BookTexture.Rectangle page = tex.pages().get(this.pageNum % tex.pages().size());
        this.width = lookup.getOrDefault("width", page.width()).asInt();
        this.height = lookup.getOrDefault("height", page.height()).asInt();
    }

    @Override
    public void initWidgets(PageWidgetHolder holder, BookRenderContext context) {
        if (this.holder.getComponents().size() < 2) {
            return;
        }
        BookTexture tex = context.getBookTexture();
        ResourceLocation loc = tex.location();
        BookTexture.FixedRectangle left = tex.left();
        BookTexture.FixedRectangle right = tex.right();
        this.leftButton = holder.addRenderableWidget(new PageImageButton(loc, this.x, this.y + this.height - left.height(), left.width(), left.height(), left.u(), left.v(), tex.texWidth(), tex.texHeight(), b -> this.changeComponent(-1)));
        this.rightButton = holder.addRenderableWidget(new PageImageButton(loc, this.x + this.width - right.width(), this.y + this.height - right.height(), right.width(), right.height(), right.u(), right.v(), tex.texWidth(), tex.texHeight(), b -> this.changeComponent(1)));
        this.updateWidgetVisibility();
    }

    @Override
    public void render(GuiGraphics graphics, BookRenderContext context, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)this.x, (float)this.y, 0.0f);
        this.holder.getComponent(this.selectedComponent).render(graphics, context, mouseX - this.x, mouseY - this.y, partialTick);
        poseStack.popPose();
    }

    protected void changeComponent(int by) {
        this.selectedComponent = Mth.clamp((int)(this.selectedComponent + by), (int)0, (int)(this.holder.getComponents().size() - 1));
        this.updateWidgetVisibility();
    }

    protected void updateWidgetVisibility() {
        if (this.selectedComponent <= 0) {
            this.selectedComponent = 0;
            this.leftButton.active = false;
        } else {
            this.leftButton.active = true;
        }
        if (this.selectedComponent >= this.holder.getComponents().size() - 1) {
            this.selectedComponent = this.holder.getComponents().size() - 1;
            this.rightButton.active = false;
        } else {
            this.rightButton.active = true;
        }
    }

    @Override
    public void tick(BookRenderContext context) {
        this.holder.getComponent(this.selectedComponent).tick(context);
    }

    @Override
    public boolean mouseClicked(BookRenderContext context, double mouseX, double mouseY, int button) {
        return this.holder.getComponent(this.selectedComponent).mouseClicked(context, mouseX - (double)this.x, mouseY - (double)this.y, button);
    }

    @Override
    public boolean mouseReleased(BookRenderContext context, double mouseX, double mouseY, int button) {
        return this.holder.getComponent(this.selectedComponent).mouseReleased(context, mouseX - (double)this.x, mouseY - (double)this.y, button);
    }

    @Override
    public boolean mouseDragged(BookRenderContext context, double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.holder.getComponent(this.selectedComponent).mouseDragged(context, mouseX - (double)this.x, mouseY - (double)this.y, button, dragX, dragY);
    }

    @Override
    public boolean mouseScrolled(BookRenderContext context, double mouseX, double mouseY, double scrollX, double scrollY) {
        return this.holder.getComponent(this.selectedComponent).mouseScrolled(context, mouseX - (double)this.x, mouseY - (double)this.y, scrollX, scrollY);
    }

    @Override
    public boolean keyPressed(BookRenderContext context, int keyCode, int scanCode, int modifiers) {
        return this.holder.getComponent(this.selectedComponent).keyPressed(context, keyCode, scanCode, modifiers);
    }

    @Override
    public boolean keyReleased(BookRenderContext context, int keyCode, int scanCode, int modifiers) {
        return this.holder.getComponent(this.selectedComponent).keyReleased(context, keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(BookRenderContext context, char codePoint, int modifiers) {
        return this.holder.getComponent(this.selectedComponent).charTyped(context, codePoint, modifiers);
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.holder.getComponent(this.selectedComponent).isMouseOver(mouseX - (double)this.x, mouseY - (double)this.y);
    }
}

