/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.page_components;

import com.google.common.reflect.TypeToken;
import java.util.List;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.Lookup;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.BookTexture;
import net.favouriteless.modopedia.api.book.page_components.BookRenderContext;
import net.favouriteless.modopedia.api.book.page_components.PageComponent;
import net.favouriteless.modopedia.api.book.page_components.PageWidgetHolder;
import net.favouriteless.modopedia.client.page_widgets.PageImageButton;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class ImagePageComponent
extends PageComponent {
    public static final ResourceLocation ID = Modopedia.id("image");
    protected List<ResourceLocation> images;
    protected int width;
    protected int height;
    protected PageImageButton leftButton;
    protected PageImageButton rightButton;
    protected int selectedImage = 0;

    @Override
    public void init(Book book, Lookup lookup, Level level) {
        super.init(book, lookup, level);
        this.images = lookup.get("images").as(new TypeToken<List<ResourceLocation>>(){});
        this.width = lookup.getOrDefault("width", 100).asInt();
        this.height = lookup.getOrDefault("height", 100).asInt();
        if (this.images.isEmpty()) {
            throw new IllegalArgumentException("Image gallery cannot have zero images in it.");
        }
    }

    @Override
    public void render(GuiGraphics graphics, BookRenderContext context, int mouseX, int mouseY, float partialTick) {
        graphics.blit(this.images.get(this.selectedImage), this.x, this.y, 0, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
    }

    @Override
    public void initWidgets(PageWidgetHolder holder, BookRenderContext context) {
        if (this.images.size() < 2) {
            return;
        }
        BookTexture bookTex = context.getBookTexture();
        ResourceLocation tex = bookTex.location();
        BookTexture.FixedRectangle left = bookTex.left();
        BookTexture.FixedRectangle right = bookTex.right();
        this.leftButton = holder.addRenderableWidget(new PageImageButton(tex, this.x, this.y + this.height - left.height(), left.width(), left.height(), left.u(), left.v(), bookTex.texWidth(), bookTex.texHeight(), b -> this.changeImage(-1)));
        this.rightButton = holder.addRenderableWidget(new PageImageButton(tex, this.x + this.width - right.width(), this.y + this.height - right.height(), right.width(), right.height(), right.u(), right.v(), bookTex.texWidth(), bookTex.texHeight(), b -> this.changeImage(1)));
        this.updateWidgetVisibility();
    }

    protected void changeImage(int by) {
        this.selectedImage = Mth.clamp((int)(this.selectedImage + by), (int)0, (int)(this.images.size() - 1));
        this.updateWidgetVisibility();
    }

    protected void updateWidgetVisibility() {
        if (this.selectedImage <= 0) {
            this.selectedImage = 0;
            this.leftButton.active = false;
        } else {
            this.leftButton.active = true;
        }
        if (this.selectedImage >= this.images.size() - 1) {
            this.selectedImage = this.images.size() - 1;
            this.rightButton.active = false;
        } else {
            this.rightButton.active = true;
        }
    }
}

