/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.page_components;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.Lookup;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.page_components.BookRenderContext;
import net.favouriteless.modopedia.api.book.page_components.PageComponent;
import net.favouriteless.modopedia.book.text.Justify;
import net.favouriteless.modopedia.book.text.TextChunk;
import net.favouriteless.modopedia.book.text.TextParser;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class TextPageComponent
extends PageComponent {
    public static final ResourceLocation ID = Modopedia.id("text");
    protected List<TextChunk> textChunks = new ArrayList<TextChunk>();
    protected int width;
    protected int lineHeight;

    @Override
    public void init(Book book, Lookup lookup, Level level) {
        super.init(book, lookup, level);
        Justify justify = lookup.getOrDefault("justify", (Object)Justify.LEFT).as(Justify.class);
        Style baseStyle = Style.EMPTY.withFont(book.getFont()).withColor(book.getTextColour());
        this.width = lookup.getOrDefault("width", book.getLineWidth()).asInt();
        Objects.requireNonNull(Minecraft.getInstance().font);
        this.lineHeight = lookup.getOrDefault("line_height", 9).asInt();
        this.textChunks = TextParser.parse(lookup.get("text").asString(), baseStyle, this.width, this.lineHeight, this.language, justify);
    }

    @Override
    public void render(GuiGraphics graphics, BookRenderContext context, int mouseX, int mouseY, float partialTicks) {
        for (TextChunk word : this.textChunks) {
            word.render(graphics, this.x, this.y, mouseX - this.x, mouseY - this.y);
        }
    }

    @Override
    public boolean mouseClicked(BookRenderContext context, double mouseX, double mouseY, int button) {
        for (TextChunk chunk : this.textChunks) {
            if (!chunk.mouseClicked(context, mouseX - (double)this.x, mouseY - (double)this.y, button)) continue;
            return true;
        }
        return false;
    }
}

