/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.page_components.item_displays;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.book.page_components.BookRenderContext;
import net.favouriteless.modopedia.api.book.page_components.ItemDisplay;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class RingsItemDisplay
implements ItemDisplay {
    public static final ResourceLocation ID = Modopedia.id("rings");
    public static final MapCodec<RingsItemDisplay> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.lazyInitialized(ItemDisplay::codec).listOf().fieldOf("displays").forGetter(d -> d.displays), (App)Codec.INT.optionalFieldOf("ring_count", (Object)6).forGetter(d -> d.ringCount), (App)Codec.INT.optionalFieldOf("radius", (Object)16).forGetter(d -> d.radius), (App)Codec.INT.optionalFieldOf("offset", (Object)8).forGetter(d -> d.offset)).apply((Applicative)instance, RingsItemDisplay::new));
    private final List<ItemDisplay> displays;
    private final int ringCount;
    private final int radius;
    private final int offset;

    public RingsItemDisplay(List<ItemDisplay> displays, int ringCount, int radius, int offset) {
        this.displays = displays;
        this.ringCount = ringCount;
        this.radius = radius;
        this.offset = offset;
        if (displays.isEmpty()) {
            throw new IllegalArgumentException("RingsItemDisplay cannot have zero child displays.");
        }
    }

    @Override
    public void render(GuiGraphics graphics, BookRenderContext context, int mouseX, int mouseY, String entry) {
        List<ItemDisplay> ring;
        int ringCount = 1;
        for (int i = 0; i < this.displays.size(); i += ring.size()) {
            ring = this.displays.subList(i, Math.min(i + this.ringCount * ringCount, this.displays.size()));
            PoseStack pose = graphics.pose();
            float a = 360.0f / (float)ring.size() * ((float)Math.PI / 180);
            float sin = Mth.sin((float)a);
            float cos = Mth.cos((float)a);
            float x = 0.0f;
            float y = -this.radius * ringCount;
            for (ItemDisplay display : ring) {
                int xr = Math.round(x) - this.offset;
                int yr = Math.round(y) - this.offset;
                pose.pushPose();
                pose.translate((float)xr, (float)yr, 0.0f);
                display.render(graphics, context, mouseX - xr, mouseY - yr, entry);
                pose.popPose();
                float xc = x;
                x = xc * cos - y * sin;
                y = xc * sin + y * cos;
            }
            ++ringCount;
        }
    }

    @Override
    public MapCodec<? extends ItemDisplay> typeCodec() {
        return CODEC;
    }
}

