/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.screens.books;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.BookContent;
import net.favouriteless.modopedia.api.book.BookType;
import net.favouriteless.modopedia.book.text.Justify;
import net.favouriteless.modopedia.book.text.TextChunk;
import net.favouriteless.modopedia.book.text.TextParser;
import net.favouriteless.modopedia.client.screens.books.BookScreen;
import net.favouriteless.modopedia.client.screens.books.ButtonListScreen;
import net.favouriteless.modopedia.client.screens.books.book_screen_pages.LandingScreenPage;
import net.favouriteless.modopedia.client.screens.books.book_screen_pages.ScreenPage;
import net.favouriteless.modopedia.common.book_types.LockedViewProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class ClassicLandingScreen<T extends BookType & LockedViewProvider>
extends ButtonListScreen<T> {
    public static final int TITLE_COLOUR = 15722290;
    protected final Component subtitle;

    public ClassicLandingScreen(Book book, T type, String language, BookContent.LocalisedBookContent content, BookScreen<?> lastScreen) {
        super(book, type, language, content, (Component)Component.translatable((String)book.getTitle()).withStyle(Style.EMPTY.withColor(15722290)), lastScreen, (Component)Component.translatable((String)"screen.modopedia.categories").withStyle(Style.EMPTY.withColor(book.getHeaderColour())), () -> content.getCategoryIds().stream().filter(c -> content.hasCategory((String)c) && content.getCategory((String)c).getDisplayOnFrontPage()).sorted(Comparator.comparingInt(o -> content.getCategory((String)o).getSortNum())).map(id -> (s, x, y, width) -> ClassicLandingScreen.createCategoryButton(s, id, x, y, width)).toList());
        this.subtitle = book.getSubtitle() != null ? Component.translatable((String)book.getSubtitle()).withStyle(Style.EMPTY.withColor(15722290).withFont(Modopedia.id("default"))) : null;
    }

    @Override
    protected ScreenPage initFirstPage() {
        String rawLandingText = this.book.getRawLandingText();
        if (rawLandingText != null) {
            rawLandingText = Language.getInstance().getOrDefault(rawLandingText);
        }
        int lineWidth = this.texture.pages().getFirst().width();
        Objects.requireNonNull(Minecraft.getInstance().font);
        int lineHeight = 9;
        List<TextChunk> landingText = TextParser.parse(rawLandingText, this.getStyle(), lineWidth, lineHeight, this.language, Justify.LEFT);
        return new LandingScreenPage(this, this.title, this.subtitle, 37, 7, 10, landingText, 0, 0);
    }

    @Override
    protected boolean isTopLevel() {
        return true;
    }
}

