/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.screens.books.book_screen_pages;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.favouriteless.modopedia.api.book.BookTexture;
import net.favouriteless.modopedia.api.book.Page;
import net.favouriteless.modopedia.api.book.page_components.BookRenderContext;
import net.favouriteless.modopedia.api.book.page_components.PageComponent;
import net.favouriteless.modopedia.api.book.page_components.PageEventListener;
import net.favouriteless.modopedia.api.book.page_components.PageRenderable;
import net.favouriteless.modopedia.api.book.page_components.PageWidgetHolder;
import net.favouriteless.modopedia.client.screens.books.BookScreen;
import net.favouriteless.modopedia.client.screens.books.book_screen_pages.ScreenPage;
import net.minecraft.client.gui.GuiGraphics;

public class EntryScreenPage
extends ScreenPage
implements PageWidgetHolder,
PageEventListener {
    protected final BookTexture.Rectangle rectangle;
    protected final List<PageRenderable> renderables = new ArrayList<PageRenderable>();
    protected final List<PageEventListener> widgets = new ArrayList<PageEventListener>();
    protected boolean dragging = false;
    protected PageEventListener focused = null;

    public EntryScreenPage(BookScreen<?> parent, BookTexture.Rectangle rectangle, Page page) {
        super(parent);
        this.rectangle = rectangle;
        for (PageComponent component : page.getComponents()) {
            this.renderables.add(component);
            this.widgets.add(component);
            component.initWidgets(this, parent);
        }
    }

    @Override
    public void render(GuiGraphics graphics, PoseStack poseStack, BookTexture.Rectangle rectangle, int mouseX, int mouseY, float partialTick) {
        for (PageRenderable renderable : this.renderables) {
            if (!renderable.shouldRender()) continue;
            renderable.render(graphics, this.parent, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public void tick(BookRenderContext context) {
        for (PageRenderable renderable : this.renderables) {
            renderable.tick(context);
        }
    }

    @Override
    public <T extends PageRenderable> T addRenderable(T renderable) {
        this.renderables.add(renderable);
        return renderable;
    }

    @Override
    public <T extends PageEventListener> T addWidget(T widget) {
        this.widgets.add(widget);
        return widget;
    }

    @Override
    public <T extends PageRenderable & PageEventListener> T addRenderableWidget(T widget) {
        this.renderables.add(widget);
        this.widgets.add(widget);
        return widget;
    }

    @Override
    public boolean mouseClicked(BookRenderContext context, double mouseX, double mouseY, int button) {
        for (PageEventListener widget : this.widgets) {
            if (!widget.mouseClicked(context, mouseX - (double)this.rectangle.u(), mouseY - (double)this.rectangle.v(), button)) continue;
            this.focused = widget;
            if (button == 0) {
                this.dragging = true;
            }
            return true;
        }
        this.focused = null;
        return false;
    }

    @Override
    public boolean mouseReleased(BookRenderContext context, double mouseX, double mouseY, int button) {
        if (button == 0 && this.dragging) {
            this.dragging = false;
            if (this.focused != null) {
                return this.focused.mouseReleased(context, mouseX - (double)this.rectangle.u(), mouseY - (double)this.rectangle.v(), button);
            }
        }
        for (PageEventListener widget : this.widgets) {
            if (!widget.mouseReleased(context, mouseX - (double)this.rectangle.u(), mouseY - (double)this.rectangle.v(), button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(BookRenderContext context, double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.focused != null && this.dragging && button == 0 && this.focused.mouseDragged(context, mouseX - (double)this.rectangle.u(), mouseY - (double)this.rectangle.v(), button, dragX, dragY);
    }

    @Override
    public boolean mouseScrolled(BookRenderContext context, double mouseX, double mouseY, double scrollX, double scrollY) {
        for (PageEventListener widget : this.widgets) {
            if (!widget.mouseScrolled(context, mouseX - (double)this.rectangle.u(), mouseY - (double)this.rectangle.v(), scrollX, scrollY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(BookRenderContext context, int keyCode, int scanCode, int modifiers) {
        return this.focused != null && this.focused.keyPressed(context, keyCode, scanCode, modifiers);
    }

    @Override
    public boolean keyReleased(BookRenderContext context, int keyCode, int scanCode, int modifiers) {
        return this.focused != null && this.focused.keyReleased(context, keyCode, scanCode, modifiers);
    }

    @Override
    public boolean charTyped(BookRenderContext context, char codePoint, int modifiers) {
        return this.focused != null && this.focused.charTyped(context, codePoint, modifiers);
    }
}

