/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.setup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.silentchaos512.gems.item.GemsFoodItem;
import net.silentchaos512.gems.item.PetSummonerItem;
import net.silentchaos512.gems.util.Gems;

public final class GemsItems {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"silentgems");
    private static final Collection<DeferredItem<? extends Item>> SIMPLE_MODEL_ITEMS = new ArrayList<DeferredItem<? extends Item>>();
    public static final DeferredItem<Item> RAW_SILVER;
    public static final DeferredItem<Item> SILVER_INGOT;
    public static final DeferredItem<Item> SILVER_NUGGET;
    public static final DeferredItem<Item> CHAOS_ESSENCE;
    public static final DeferredItem<PetSummonerItem> SUMMON_KITTY;
    public static final DeferredItem<PetSummonerItem> SUMMON_PUPPY;
    public static final DeferredItem<Item> POTATO_ON_A_STICK;
    public static final DeferredItem<Item> SUGAR_COOKIE;
    public static final DeferredItem<Item> CUP_OF_COFFEE;
    public static final DeferredItem<Item> UNCOOKED_MEATY_STEW;
    public static final DeferredItem<Item> MEATY_STEW;
    public static final DeferredItem<Item> UNCOOKED_FISHY_STEW;
    public static final DeferredItem<Item> FISHY_STEW;
    public static final DeferredItem<Item> IRON_POTATO;

    private GemsItems() {
    }

    public static Collection<DeferredItem<? extends Item>> getSimpleModelItems() {
        return Collections.unmodifiableCollection(SIMPLE_MODEL_ITEMS);
    }

    private static <T extends Item> DeferredItem<T> register(String name, Supplier<T> item) {
        return ITEMS.register(name, item);
    }

    private static <T extends Item> DeferredItem<T> registerSimpleModel(String name, Supplier<T> item) {
        DeferredItem<T> ret = GemsItems.register(name, item);
        SIMPLE_MODEL_ITEMS.add(ret);
        return ret;
    }

    private static DeferredItem<Item> registerCraftingItem(String name) {
        return GemsItems.registerSimpleModel(name, () -> new Item(GemsItems.baseProps()));
    }

    private static DeferredItem<Item> registerFood(String name, @Nullable ItemLike returnItem, FoodProperties.Builder foodBuilder) {
        DeferredItem<Item> ret = GemsItems.register(name, () -> new GemsFoodItem(foodBuilder, returnItem, GemsItems.baseProps()));
        SIMPLE_MODEL_ITEMS.add(ret);
        return ret;
    }

    private static Item.Properties baseProps() {
        return new Item.Properties();
    }

    private static Item.Properties unstackableProps() {
        return GemsItems.baseProps().stacksTo(1);
    }

    static {
        Gems.registerItems();
        RAW_SILVER = GemsItems.registerCraftingItem("raw_silver");
        SILVER_INGOT = GemsItems.registerCraftingItem("silver_ingot");
        SILVER_NUGGET = GemsItems.registerCraftingItem("silver_nugget");
        CHAOS_ESSENCE = GemsItems.registerCraftingItem("chaos_essence");
        SUMMON_KITTY = GemsItems.registerSimpleModel("summon_kitty", () -> new PetSummonerItem(PetSummonerItem::getCat, GemsItems.baseProps()));
        SUMMON_PUPPY = GemsItems.registerSimpleModel("summon_puppy", () -> new PetSummonerItem(PetSummonerItem::getDog, GemsItems.baseProps()));
        POTATO_ON_A_STICK = GemsItems.registerFood("potato_on_a_stick", (ItemLike)Items.STICK, new FoodProperties.Builder().nutrition(6).saturationModifier(0.7f));
        SUGAR_COOKIE = GemsItems.registerFood("sugar_cookie", null, new FoodProperties.Builder().nutrition(2).saturationModifier(0.4f).alwaysEdible().effect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 600), 1.0f).effect(() -> new MobEffectInstance(MobEffects.DIG_SPEED, 400), 1.0f));
        CUP_OF_COFFEE = GemsItems.registerFood("cup_of_coffee", null, new FoodProperties.Builder().nutrition(1).saturationModifier(0.2f).alwaysEdible().effect(() -> new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 3600), 1.0f).effect(() -> new MobEffectInstance(MobEffects.DIG_SPEED, 1800), 1.0f));
        UNCOOKED_MEATY_STEW = GemsItems.registerFood("uncooked_meaty_stew", (ItemLike)Items.BOWL, new FoodProperties.Builder().nutrition(4).saturationModifier(0.6f));
        MEATY_STEW = GemsItems.registerFood("meaty_stew", (ItemLike)Items.BOWL, new FoodProperties.Builder().nutrition(12).saturationModifier(1.6f));
        UNCOOKED_FISHY_STEW = GemsItems.registerFood("uncooked_fishy_stew", (ItemLike)Items.BOWL, new FoodProperties.Builder().nutrition(4).saturationModifier(0.5f));
        FISHY_STEW = GemsItems.registerFood("fishy_stew", (ItemLike)Items.BOWL, new FoodProperties.Builder().nutrition(10).saturationModifier(1.2f));
        IRON_POTATO = GemsItems.registerFood("iron_potato", null, new FoodProperties.Builder().nutrition(9).saturationModifier(0.9f).alwaysEdible().effect(() -> new MobEffectInstance(MobEffects.ABSORPTION, 12000, 4), 1.0f).effect(() -> new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 6000, 0), 1.0f).effect(() -> new MobEffectInstance(MobEffects.DAMAGE_BOOST, 6000, 1), 1.0f));
    }
}

