/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.setup;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class GemsTags {

    public static final class EntityTypes {
        public static final TagKey<EntityType<?>> COFFEE_PRODUCERS = EntityTypes.gems("coffee_producers");

        private static TagKey<EntityType<?>> gems(String path) {
            return EntityTypes.tag("silentgems", path);
        }

        private static TagKey<EntityType<?>> tag(String namespace, String path) {
            return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path));
        }
    }

    public static final class Items {
        public static final TagKey<Item> INGOTS_SILVER = Items.common("ingots/silver");
        public static final TagKey<Item> ORES_CHAOS = Items.common("ores/chaos");
        public static final TagKey<Item> ORES_SILVER = Items.common("ores/silver");
        public static final TagKey<Item> NUGGETS_SILVER = Items.common("nuggets/silver");
        public static final TagKey<Item> GEM_ORES = Items.gems("ores");
        public static final TagKey<Item> GEMS = Items.gems("gems");
        public static final TagKey<Item> GLOWROSES = Items.gems("glowroses");
        public static final TagKey<Item> STEW_FISH = Items.gems("stew_fish");
        public static final TagKey<Item> STEW_MEAT = Items.gems("stew_meat");
        public static final TagKey<Item> FLOWER_BASKET_CAN_STORE = Items.gems("flower_basket_can_store");
        public static final TagKey<Item> GEM_BAG_CAN_STORE = Items.gems("gem_bag_can_store");

        private Items() {
        }

        private static TagKey<Item> common(String path) {
            return Items.tag("c", path);
        }

        private static TagKey<Item> gems(String path) {
            return Items.tag("silentgems", path);
        }

        private static TagKey<Item> tag(String namespace, String name) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)name));
        }
    }

    public static final class Blocks {
        public static final TagKey<Block> ORES_CHAOS = Blocks.common("ores/chaos");
        public static final TagKey<Block> ORES_SILVER = Blocks.common("ores/silver");
        public static final TagKey<Block> GEM_ORES = Blocks.gems("ores");
        public static final TagKey<Block> GLOWROSES = Blocks.gems("glowroses");

        private Blocks() {
        }

        private static TagKey<Block> common(String path) {
            return Blocks.tag("c", path);
        }

        private static TagKey<Block> gems(String path) {
            return Blocks.tag("silentgems", path);
        }

        private static TagKey<Block> tag(String namespace, String name) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)namespace, (String)name));
        }
    }
}

